/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.support.api.matchers;

import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.LiveHttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class HttpResponseBodyMatcher<T extends LiveHttpResponse>
extends TypeSafeMatcher<T> {
    private final Matcher<String> matcher;

    public static <T extends LiveHttpResponse> Matcher<T> hasBody(Matcher<String> matcher) {
        return new HttpResponseBodyMatcher<T>(matcher);
    }

    public static <T extends LiveHttpResponse> Matcher<T> hasBody(String content) {
        return new HttpResponseBodyMatcher<T>((Matcher<String>)CoreMatchers.equalTo((Object)content));
    }

    public HttpResponseBodyMatcher(Matcher<String> matcher) {
        this.matcher = matcher;
    }

    public boolean matchesSafely(T actual) {
        return this.matcher.matches((Object)((HttpResponse)Mono.from((Publisher)actual.aggregate(0x100000)).block()).bodyAs(StandardCharsets.UTF_8));
    }

    protected void describeMismatchSafely(T item, Description mismatchDescription) {
        mismatchDescription.appendText("content was '" + ((HttpResponse)Mono.from((Publisher)item.aggregate(0x100000)).block()).bodyAs(StandardCharsets.UTF_8) + "'");
    }

    public void describeTo(Description description) {
        description.appendText("content with ");
        this.matcher.describeTo(description);
    }

    private <T> T await(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

