/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.support.api.matchers;

import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.LiveHttpResponse;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HttpResponseStatusMatcher
extends TypeSafeMatcher<LiveHttpResponse> {
    private final HttpResponseStatus status;

    public static Matcher<LiveHttpResponse> hasStatus(HttpResponseStatus status) {
        return new HttpResponseStatusMatcher(status);
    }

    HttpResponseStatusMatcher(HttpResponseStatus status) {
        this.status = status;
    }

    public boolean matchesSafely(LiveHttpResponse request) {
        return Objects.equals(this.status, request.status());
    }

    protected void describeMismatchSafely(LiveHttpResponse response, Description mismatchDescription) {
        mismatchDescription.appendText("status with value of ").appendValue((Object)response.status());
    }

    public void describeTo(Description description) {
        description.appendText("status with value of ").appendValue((Object)this.status.code());
    }
}

