/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.support.netty;

import com.hotels.styx.api.HttpHeaderNames;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.Charset;

public class HttpMessageSupport {
    public static HttpResponse httpResponse(HttpResponseStatus status, String body) {
        ByteBuf content = Unpooled.copiedBuffer((byte[])body.getBytes(Charset.forName("US-ASCII")));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        HttpHeaders.setContentLength((HttpMessage)response, (long)content.writerIndex());
        return response;
    }

    public static ByteBuf httpResponseAsBuf(HttpResponseStatus status, String body) {
        return HttpMessageSupport.httpMessageToBytes((HttpMessage)HttpMessageSupport.httpResponse(status, body));
    }

    public static HttpRequest httpRequest(HttpMethod method, String url, String body) {
        ByteBuf content = Unpooled.copiedBuffer((byte[])body.getBytes(Charset.forName("US-ASCII")));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, url, content);
        HttpHeaders.setContentLength((HttpMessage)request, (long)content.writerIndex());
        return request;
    }

    public static HttpRequest httpRequest(HttpMethod method, String url) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, url);
        request.headers().set(HttpHeaderNames.HOST, (Object)url);
        return request;
    }

    public static ByteBuf httpRequestAsBuf(HttpMethod method, String url, String body) {
        return HttpMessageSupport.httpMessageToBytes((HttpMessage)HttpMessageSupport.httpRequest(method, url, body));
    }

    public static ByteBuf httpRequestAsBuf(HttpMethod method, String url) {
        return HttpMessageSupport.httpMessageToBytes((HttpMessage)HttpMessageSupport.httpRequest(method, url));
    }

    public static ByteBuf httpMessageToBytes(HttpMessage message) {
        Object codec = message instanceof HttpRequest ? new HttpClientCodec() : new HttpServerCodec();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{codec, new HttpObjectAggregator(102400)});
        channel.writeOutbound(new Object[]{message});
        CompositeByteBuf httpBytes = Unpooled.compositeBuffer();
        Object result = channel.readOutbound();
        while (result != null) {
            httpBytes.addComponent((ByteBuf)result);
            result = channel.readOutbound();
        }
        return httpBytes.copy(0, httpBytes.capacity());
    }
}

