/*
  Copyright (C) 2013-2020 Expedia Inc.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.hotels.styx.routing.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotels.styx.StyxConfig;

import static com.hotels.styx.routing.config.ConfigVersionResolver.Version.ROUTING_CONFIG_V1;
import static com.hotels.styx.routing.config.ConfigVersionResolver.Version.ROUTING_CONFIG_V2;

/**
 * Works out the Styx configuration version for backwards compatibility purposes.
 */
public final class ConfigVersionResolver {

    /**
     * Routing configuration version.
     */
    public enum Version {
        ROUTING_CONFIG_V1,
        ROUTING_CONFIG_V2
    };

    private ConfigVersionResolver() {
    }

    public static Version configVersion(StyxConfig config) {
        if (config.get("httpPipeline", JsonNode.class).isPresent()) {
            return ROUTING_CONFIG_V2;
        } else {
            return ROUTING_CONFIG_V1;
        }
    }
}
