/*
  Copyright (C) 2013-2020 Expedia Inc.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.hotels.styx.startup;

import com.hotels.styx.Environment;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.routing.RoutingObjectRecord;
import com.hotels.styx.routing.db.StyxObjectStore;

import java.util.Map;

import static com.hotels.styx.serviceproviders.ServiceProvision.loadServices;

/**
 * Loads services from environment.
 */
public interface ServicesLoader {
    ServicesLoader SERVICES_FROM_CONFIG = (environment, routeDatabase) -> loadServices(environment.configuration(), environment, "services", StyxService.class);

    Map<String, StyxService> load(Environment environment, StyxObjectStore<RoutingObjectRecord> routeDatabase);
}
