/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx;

import com.google.common.collect.ImmutableList;
import com.hotels.styx.StyxConfig;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.configuration.ConfigurationContextResolver;
import com.hotels.styx.common.format.HttpMessageFormatter;
import com.hotels.styx.proxy.interceptors.ConfigurationContextResolverInterceptor;
import com.hotels.styx.proxy.interceptors.HopByHopHeadersRemovingInterceptor;
import com.hotels.styx.proxy.interceptors.HttpMessageLoggingInterceptor;
import com.hotels.styx.proxy.interceptors.RequestEnrichingInterceptor;
import com.hotels.styx.proxy.interceptors.TcpTunnelRequestRejector;
import com.hotels.styx.proxy.interceptors.UnexpectedRequestContentLengthRemover;
import com.hotels.styx.proxy.interceptors.ViaHeaderAppendingInterceptor;
import java.util.List;

final class BuiltInInterceptors {
    private BuiltInInterceptors() {
    }

    static List<HttpInterceptor> internalStyxInterceptors(StyxConfig config, HttpMessageFormatter httpMessageFormatter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean loggingEnabled = config.get("request-logging.inbound.enabled", Boolean.class).orElse(false);
        boolean longFormatEnabled = config.get("request-logging.inbound.longFormat", Boolean.class).orElse(false);
        if (loggingEnabled) {
            builder.add((Object)new HttpMessageLoggingInterceptor(longFormatEnabled, httpMessageFormatter));
        }
        builder.add((Object)new TcpTunnelRequestRejector()).add((Object)new ConfigurationContextResolverInterceptor(ConfigurationContextResolver.EMPTY_CONFIGURATION_CONTEXT_RESOLVER)).add((Object)new UnexpectedRequestContentLengthRemover()).add((Object)new ViaHeaderAppendingInterceptor()).add((Object)new HopByHopHeadersRemovingInterceptor()).add((Object)new RequestEnrichingInterceptor(config.styxHeaderConfig()));
        return builder.build();
    }
}

