/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx;

import com.google.common.eventbus.EventBus;
import com.hotels.styx.StyxConfig;
import com.hotels.styx.Version;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.api.metrics.codahale.CodaHaleMetricRegistry;
import com.hotels.styx.common.format.DefaultHttpMessageFormatter;
import com.hotels.styx.common.format.HttpMessageFormatter;
import com.hotels.styx.proxy.HttpErrorStatusCauseLogger;
import com.hotels.styx.proxy.HttpErrorStatusMetrics;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import com.hotels.styx.server.HttpErrorStatusListener;
import com.hotels.styx.server.ServerEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class Environment
implements com.hotels.styx.api.Environment {
    private final Version version;
    private final EventBus eventBus;
    private final List<NamedPlugin> plugins;
    private final StyxConfig configuration;
    private final HttpErrorStatusListener httpErrorStatusListener;
    private final ServerEnvironment serverEnvironment;
    private final HttpMessageFormatter httpMessageFormatter;

    private Environment(Builder builder) {
        this.eventBus = Environment.firstNonNull(builder.eventBus, () -> new EventBus("Styx"));
        this.plugins = new ArrayList<NamedPlugin>();
        this.configuration = builder.configuration;
        this.version = Environment.firstNonNull(builder.version, Version::newVersion);
        this.serverEnvironment = new ServerEnvironment(Environment.firstNonNull(builder.metricRegistry, CodaHaleMetricRegistry::new));
        this.httpMessageFormatter = builder.httpMessageFormatter;
        this.httpErrorStatusListener = HttpErrorStatusListener.compose((HttpErrorStatusListener[])new HttpErrorStatusListener[]{new HttpErrorStatusCauseLogger(this.httpMessageFormatter), new HttpErrorStatusMetrics(this.serverEnvironment.metricRegistry())});
    }

    private static <T> T firstNonNull(T one, Supplier<T> two) {
        return one != null ? one : two.get();
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public List<NamedPlugin> plugins() {
        return this.plugins;
    }

    public Version buildInfo() {
        return this.version;
    }

    public HttpErrorStatusListener errorListener() {
        return this.httpErrorStatusListener;
    }

    public StyxConfig configuration() {
        return this.configuration;
    }

    public MetricRegistry metricRegistry() {
        return this.serverEnvironment.metricRegistry();
    }

    @Deprecated
    public StyxConfig styxConfig() {
        return this.configuration();
    }

    public ServerEnvironment serverEnvironment() {
        return this.serverEnvironment;
    }

    public HttpMessageFormatter httpMessageFormatter() {
        return this.httpMessageFormatter;
    }

    public static class Builder {
        private MetricRegistry metricRegistry;
        private Version version;
        private EventBus eventBus;
        private StyxConfig configuration = StyxConfig.defaultConfig();
        private HttpMessageFormatter httpMessageFormatter = new DefaultHttpMessageFormatter();

        public Builder configuration(StyxConfig configuration) {
            this.configuration = Objects.requireNonNull(configuration);
            return this;
        }

        public Builder metricRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        public Builder buildInfo(Version version) {
            this.version = version;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Builder httpMessageFormatter(HttpMessageFormatter httpMessageFormatter) {
            this.httpMessageFormatter = Objects.requireNonNull(httpMessageFormatter);
            return this;
        }

        public Environment build() {
            return new Environment(this);
        }
    }
}

