/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx;

import com.codahale.metrics.Histogram;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.common.format.HttpMessageFormatter;
import com.hotels.styx.proxy.HttpCompressor;
import com.hotels.styx.proxy.ServerProtocolDistributionRecorder;
import com.hotels.styx.proxy.encoders.ConfigurableUnwiseCharsEncoder;
import com.hotels.styx.server.ConnectorConfig;
import com.hotels.styx.server.HttpErrorStatusListener;
import com.hotels.styx.server.HttpsConnectorConfig;
import com.hotels.styx.server.RequestProgressListener;
import com.hotels.styx.server.RequestStatsCollector;
import com.hotels.styx.server.netty.NettyServerConfig;
import com.hotels.styx.server.netty.ServerConnector;
import com.hotels.styx.server.netty.ServerConnectorFactory;
import com.hotels.styx.server.netty.SslContexts;
import com.hotels.styx.server.netty.codec.NettyToStyxRequestDecoder;
import com.hotels.styx.server.netty.codec.UnwiseCharsEncoder;
import com.hotels.styx.server.netty.connectors.HttpPipelineHandler;
import com.hotels.styx.server.netty.connectors.ResponseEnhancer;
import com.hotels.styx.server.netty.handlers.ChannelActivityEventConstrainer;
import com.hotels.styx.server.netty.handlers.ChannelStatisticsHandler;
import com.hotels.styx.server.netty.handlers.ExcessConnectionRejector;
import com.hotels.styx.server.netty.handlers.RequestTimeoutHandler;
import com.hotels.styx.server.track.CurrentRequestTracker;
import com.hotels.styx.server.track.RequestTracker;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConnectorFactory
implements ServerConnectorFactory {
    private final MetricRegistry metrics;
    private final HttpErrorStatusListener errorStatusListener;
    private final NettyServerConfig serverConfig;
    private final String unwiseCharacters;
    private final ResponseEnhancer responseEnhancer;
    private final boolean requestTracking;
    private final HttpMessageFormatter httpMessageFormatter;
    private final CharSequence originsHeader;

    public ProxyConnectorFactory(NettyServerConfig serverConfig, MetricRegistry metrics, HttpErrorStatusListener errorStatusListener, String unwiseCharacters, ResponseEnhancer responseEnhancer, boolean requestTracking, HttpMessageFormatter httpMessageFormatter, CharSequence originsHeader) {
        this.serverConfig = Objects.requireNonNull(serverConfig);
        this.metrics = Objects.requireNonNull(metrics);
        this.errorStatusListener = Objects.requireNonNull(errorStatusListener);
        this.unwiseCharacters = Objects.requireNonNull(unwiseCharacters);
        this.responseEnhancer = Objects.requireNonNull(responseEnhancer);
        this.requestTracking = requestTracking;
        this.httpMessageFormatter = httpMessageFormatter;
        this.originsHeader = originsHeader;
    }

    public ServerConnector create(ConnectorConfig config) {
        return new ProxyConnector(config, this);
    }

    private static final class ProxyConnector
    implements ServerConnector {
        private final ConnectorConfig config;
        private final NettyServerConfig serverConfig;
        private final MetricRegistry metrics;
        private final HttpErrorStatusListener httpErrorStatusListener;
        private final ChannelStatisticsHandler channelStatsHandler;
        private final ExcessConnectionRejector excessConnectionRejector;
        private final RequestStatsCollector requestStatsCollector;
        private final ConfigurableUnwiseCharsEncoder unwiseCharEncoder;
        private final Optional<SslContext> sslContext;
        private final ResponseEnhancer responseEnhancer;
        private final RequestTracker requestTracker;
        private final HttpMessageFormatter httpMessageFormatter;
        private final CharSequence originsHeader;

        private ProxyConnector(ConnectorConfig config, ProxyConnectorFactory factory) {
            this.config = Objects.requireNonNull(config);
            this.responseEnhancer = Objects.requireNonNull(factory.responseEnhancer);
            this.serverConfig = Objects.requireNonNull(factory.serverConfig);
            this.metrics = Objects.requireNonNull(factory.metrics);
            this.httpErrorStatusListener = Objects.requireNonNull(factory.errorStatusListener);
            this.channelStatsHandler = new ChannelStatisticsHandler(this.metrics);
            this.requestStatsCollector = new RequestStatsCollector(this.metrics.scope("requests"));
            this.excessConnectionRejector = new ExcessConnectionRejector((ChannelGroup)new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE), this.serverConfig.maxConnectionsCount());
            this.unwiseCharEncoder = new ConfigurableUnwiseCharsEncoder(factory.unwiseCharacters);
            this.sslContext = this.isHttps() ? Optional.of(SslContexts.newSSLContext((HttpsConnectorConfig)((HttpsConnectorConfig)config), (MetricRegistry)this.metrics)) : Optional.empty();
            this.requestTracker = factory.requestTracking ? CurrentRequestTracker.INSTANCE : RequestTracker.NO_OP;
            this.httpMessageFormatter = factory.httpMessageFormatter;
            this.originsHeader = factory.originsHeader;
        }

        public String type() {
            return this.config.type();
        }

        public int port() {
            return this.config.port();
        }

        public void configure(Channel channel, HttpHandler httpPipeline) {
            this.sslContext.ifPresent(ssl -> {
                SslHandler sslHandler = ssl.newHandler(channel.alloc());
                channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
            });
            channel.pipeline().addLast("connection-throttler", (ChannelHandler)this.excessConnectionRejector).addLast("channel-activity-event-constrainer", (ChannelHandler)new ChannelActivityEventConstrainer()).addLast("idle-handler", (ChannelHandler)new IdleStateHandler((long)this.serverConfig.requestTimeoutMillis(), 0L, (long)this.serverConfig.keepAliveTimeoutMillis(), TimeUnit.MILLISECONDS)).addLast("channel-stats", (ChannelHandler)this.channelStatsHandler).addLast("http-server-codec", (ChannelHandler)new HttpServerCodec(this.serverConfig.maxInitialLength(), this.serverConfig.maxHeaderSize(), this.serverConfig.maxChunkSize(), true)).addLast("timeout-handler", (ChannelHandler)new RequestTimeoutHandler()).addLast("keep-alive-handler", (ChannelHandler)new IdleTransactionConnectionCloser(this.metrics)).addLast("server-protocol-distribution-recorder", (ChannelHandler)new ServerProtocolDistributionRecorder(this.metrics, this.sslContext.isPresent())).addLast("styx-decoder", (ChannelHandler)this.requestTranslator(this.serverConfig.keepAliveTimeoutMillis())).addLast("proxy", (ChannelHandler)new HttpPipelineHandler.Builder(httpPipeline).responseEnhancer(this.responseEnhancer).errorStatusListener(this.httpErrorStatusListener).progressListener((RequestProgressListener)this.requestStatsCollector).metricRegistry(this.metrics).secure(this.sslContext.isPresent()).requestTracker(this.requestTracker).xOriginsHeader(this.originsHeader).build());
            if (this.serverConfig.compressResponses()) {
                channel.pipeline().addBefore("styx-decoder", "compression", (ChannelHandler)new HttpCompressor());
            }
        }

        private NettyToStyxRequestDecoder requestTranslator(int inactivityTimeoutMs) {
            return new NettyToStyxRequestDecoder.Builder().unwiseCharEncoder((UnwiseCharsEncoder)this.unwiseCharEncoder).httpMessageFormatter(this.httpMessageFormatter).inactivityTimeoutMs((long)inactivityTimeoutMs).build();
        }

        private boolean isHttps() {
            return "https".equals(this.config.type());
        }

        private static class IdleTransactionConnectionCloser
        extends ChannelDuplexHandler {
            private static final Logger LOGGER = LoggerFactory.getLogger(IdleTransactionConnectionCloser.class);
            private final Histogram idleConnectionClosed;
            private final MetricRegistry metricRegistry;
            private volatile boolean httpTransactionOngoing;

            IdleTransactionConnectionCloser(MetricRegistry metricRegistry) {
                this.metricRegistry = metricRegistry.scope("connections");
                this.idleConnectionClosed = this.metricRegistry.histogram("idleClosed");
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof HttpRequest) {
                    this.httpTransactionOngoing = true;
                }
                super.channelRead(ctx, msg);
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                if (msg instanceof LastHttpContent) {
                    this.httpTransactionOngoing = false;
                }
                super.write(ctx, msg, promise);
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                IdleStateEvent e;
                if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.ALL_IDLE && !this.httpTransactionOngoing && ctx.channel().isActive()) {
                    LOGGER.warn("Closing an idle connection={}", (Object)ctx.channel().remoteAddress());
                    ctx.close();
                    this.idleConnectionClosed.update(1);
                }
            }
        }
    }
}

