/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx;

import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.config.schema.SchemaValidationException;
import com.hotels.styx.config.validator.DocumentFormat;
import com.hotels.styx.infrastructure.configuration.yaml.YamlConfiguration;
import com.hotels.styx.routing.config.Builtins;
import java.util.Optional;

final class ServerConfigSchema {
    private static final DocumentFormat.Builder STYX_SERVER_CONFIGURATION_SCHEMA_BUILDER;

    private ServerConfigSchema() {
    }

    static Optional<String> validateServerConfiguration(YamlConfiguration yamlConfiguration) {
        try {
            STYX_SERVER_CONFIGURATION_SCHEMA_BUILDER.build().validateObject(yamlConfiguration.root());
            return Optional.empty();
        }
        catch (SchemaValidationException e) {
            return Optional.of(e.getMessage());
        }
    }

    static {
        Schema.FieldType serverConnectorsSchema = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"http", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"port", (Schema.FieldType)SchemaDsl.integer())})), SchemaDsl.optional((String)"https", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"port", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"sslProvider", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"certificateFile", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"certificateKeyFile", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"sessionTimeoutMillis", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"sessionCacheSize", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"cipherSuites", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.string())), SchemaDsl.optional((String)"protocols", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.string()))}))});
        Schema.FieldType logFormatSchema = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"enabled", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.optional((String)"longFormat", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.atLeastOne((String[])new String[]{"enabled", "longFormat"})});
        STYX_SERVER_CONFIGURATION_SCHEMA_BUILDER = DocumentFormat.newDocument().rootSchema(SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"proxy", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"compressResponses", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.field((String)"connectors", (Schema.FieldType)serverConnectorsSchema), SchemaDsl.optional((String)"bossThreadsCount", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"clientWorkerThreadsCount", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"workerThreadsCount", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"tcpNoDelay", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.optional((String)"nioReuseAddress", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.optional((String)"nioKeepAlive", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.optional((String)"maxInitialLength", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"maxHeaderSize", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"maxChunkSize", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"maxContentLength", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"requestTimeoutMillis", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"keepAliveTimeoutMillis", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"maxConnectionsCount", (Schema.FieldType)SchemaDsl.integer())})), SchemaDsl.field((String)"admin", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"connectors", (Schema.FieldType)serverConnectorsSchema), SchemaDsl.optional((String)"bossThreadsCount", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"workerThreadsCount", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"tcpNoDelay", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.optional((String)"nioReuseAddress", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.optional((String)"nioKeepAlive", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.optional((String)"maxInitialLength", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"maxHeaderSize", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"maxChunkSize", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"maxContentLength", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"metricsCache", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"enabled", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.field((String)"expirationMillis", (Schema.FieldType)SchemaDsl.integer())}))})), SchemaDsl.optional((String)"executors", (Schema.FieldType)SchemaDsl.map((Schema.FieldType)SchemaDsl.routingObject())), SchemaDsl.optional((String)"services", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"factories", (Schema.FieldType)SchemaDsl.map((Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.opaque()})))})), SchemaDsl.optional((String)"providers", (Schema.FieldType)SchemaDsl.map((Schema.FieldType)SchemaDsl.routingObject())), SchemaDsl.optional((String)"servers", (Schema.FieldType)SchemaDsl.map((Schema.FieldType)SchemaDsl.routingObject())), SchemaDsl.optional((String)"url", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"encoding", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"unwiseCharactersToEncode", (Schema.FieldType)SchemaDsl.string())}))})), SchemaDsl.optional((String)"request-logging", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"inbound", (Schema.FieldType)logFormatSchema), SchemaDsl.optional((String)"outbound", (Schema.FieldType)logFormatSchema), SchemaDsl.atLeastOne((String[])new String[]{"inbound", "outbound"}), SchemaDsl.optional((String)"hideHeaders", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.string())), SchemaDsl.optional((String)"hideCookies", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.string()))})), SchemaDsl.optional((String)"styxHeaders", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"styxInfo", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"name", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"valueFormat", (Schema.FieldType)SchemaDsl.string())})), SchemaDsl.optional((String)"originId", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"name", (Schema.FieldType)SchemaDsl.string())})), SchemaDsl.optional((String)"requestId", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"name", (Schema.FieldType)SchemaDsl.string())})), SchemaDsl.atLeastOne((String[])new String[]{"styxInfo", "originId", "requestId"})})), SchemaDsl.optional((String)"include", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"retrypolicy", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.opaque()})), SchemaDsl.optional((String)"loadBalancing", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.opaque()})), SchemaDsl.optional((String)"plugins", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"active", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"all", (Schema.FieldType)SchemaDsl.map((Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.opaque()})))})), SchemaDsl.optional((String)"jvmRouteName", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"originRestrictionCookie", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"responseInfoHeaderFormat", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"httpPipeline", (Schema.FieldType)SchemaDsl.routingObject()), SchemaDsl.optional((String)"logFormat", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"userDefined", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.opaque()})), SchemaDsl.optional((String)"requestTracking", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.optional((String)"routingObjects", (Schema.FieldType)SchemaDsl.map((Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"name", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.field((String)"type", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"tags", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.string())), SchemaDsl.optional((String)"config", (Schema.FieldType)SchemaDsl.union((String)"type"))})))}));
        Builtins.BUILTIN_HANDLER_SCHEMAS.forEach((arg_0, arg_1) -> ((DocumentFormat.Builder)STYX_SERVER_CONFIGURATION_SCHEMA_BUILDER).typeExtension(arg_0, arg_1));
        Builtins.BUILTIN_SERVICE_PROVIDER_SCHEMAS.forEach((arg_0, arg_1) -> ((DocumentFormat.Builder)STYX_SERVER_CONFIGURATION_SCHEMA_BUILDER).typeExtension(arg_0, arg_1));
        Builtins.BUILTIN_SERVER_SCHEMAS.forEach((arg_0, arg_1) -> ((DocumentFormat.Builder)STYX_SERVER_CONFIGURATION_SCHEMA_BUILDER).typeExtension(arg_0, arg_1));
        Builtins.INTERCEPTOR_SCHEMAS.forEach((arg_0, arg_1) -> ((DocumentFormat.Builder)STYX_SERVER_CONFIGURATION_SCHEMA_BUILDER).typeExtension(arg_0, arg_1));
        Builtins.BUILTIN_EXECUTOR_SCHEMAS.forEach((arg_0, arg_1) -> ((DocumentFormat.Builder)STYX_SERVER_CONFIGURATION_SCHEMA_BUILDER).typeExtension(arg_0, arg_1));
    }
}

