/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx;

import com.hotels.styx.api.Resource;
import com.hotels.styx.common.Preconditions;
import com.hotels.styx.common.io.ResourceFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class StartupConfig {
    static final String STYX_HOME_VAR_NAME = "STYX_HOME";
    static final String CONFIG_FILE_LOCATION_VAR_NAME = "CONFIG_FILE_LOCATION";
    static final String LOGBACK_CONFIG_LOCATION_VAR_NAME = "LOG_CONFIG_LOCATION";
    private final Path styxHome;
    private final Resource logConfigLocation;
    private final Resource configFileLocation;

    private StartupConfig(Builder builder) {
        this.styxHome = builder.styxHome();
        this.configFileLocation = builder.configFileLocation();
        this.logConfigLocation = builder.logbackConfigLocation();
    }

    static StartupConfig defaultStartupConfig() {
        return new Builder().build();
    }

    public static StartupConfig load() {
        String logbackConfigLocation;
        String styxHome = System.getProperty(STYX_HOME_VAR_NAME);
        Preconditions.checkArgument((styxHome != null ? 1 : 0) != 0, (String)"No system property %s has been defined.", (Object[])new Object[]{STYX_HOME_VAR_NAME});
        Preconditions.checkArgument((boolean)Files.isReadable(Paths.get(styxHome, new String[0])), (String)"%s=%s is not a readable configuration path.", (Object[])new Object[]{STYX_HOME_VAR_NAME, styxHome});
        String configFileLocation = System.getProperty(CONFIG_FILE_LOCATION_VAR_NAME);
        if (configFileLocation == null) {
            configFileLocation = Paths.get(styxHome, new String[0]).resolve("conf/default.yml").toString();
        }
        if ((logbackConfigLocation = System.getProperty(LOGBACK_CONFIG_LOCATION_VAR_NAME)) == null) {
            logbackConfigLocation = Paths.get(styxHome, new String[0]).resolve("conf/logback.xml").toString();
        }
        return new Builder().styxHome(styxHome).configFileLocation(configFileLocation).logbackConfigLocation(logbackConfigLocation).build();
    }

    public static Builder newStartupConfigBuilder() {
        return new Builder();
    }

    public Path styxHome() {
        return this.styxHome;
    }

    public Resource logConfigLocation() {
        return this.logConfigLocation;
    }

    public Resource configFileLocation() {
        return this.configFileLocation;
    }

    public String toString() {
        return new StringBuilder(96).append(this.getClass().getSimpleName()).append("{STYX_HOME=").append(this.styxHome).append(", CONFIG_FILE_LOCATION=").append(this.configFileLocation).append(", LOG_CONFIG_LOCATION=").append(this.logConfigLocation).append('}').toString();
    }

    public static final class Builder {
        private String styxHome = ".";
        private String configFileLocation = "classpath:conf/default.yml";
        private String logbackConfigLocation = "classpath:conf/logback.xml";

        private Builder() {
        }

        Path styxHome() {
            return Paths.get(this.styxHome, new String[0]);
        }

        Resource configFileLocation() {
            return ResourceFactory.newResource((String)this.configFileLocation);
        }

        Resource logbackConfigLocation() {
            return ResourceFactory.newResource((String)this.logbackConfigLocation);
        }

        public Builder styxHome(String styxHome) {
            Preconditions.checkNotEmpty((String)styxHome);
            this.styxHome = styxHome;
            return this;
        }

        public Builder configFileLocation(String configFileLocation) {
            Preconditions.checkNotEmpty((String)configFileLocation);
            this.configFileLocation = configFileLocation;
            return this;
        }

        public Builder logbackConfigLocation(String logbackConfigLocation) {
            Preconditions.checkNotEmpty((String)logbackConfigLocation);
            this.logbackConfigLocation = logbackConfigLocation;
            return this;
        }

        public StartupConfig build() {
            return new StartupConfig(this);
        }
    }
}

