/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx;

import com.hotels.styx.ServerConfigSchema;
import com.hotels.styx.StartupConfig;
import com.hotels.styx.admin.AdminServerConfig;
import com.hotels.styx.api.Resource;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.client.StyxHeaderConfig;
import com.hotels.styx.common.Strings;
import com.hotels.styx.common.io.ResourceFactory;
import com.hotels.styx.config.schema.SchemaValidationException;
import com.hotels.styx.infrastructure.configuration.ConfigurationParser;
import com.hotels.styx.infrastructure.configuration.ConfigurationSource;
import com.hotels.styx.infrastructure.configuration.yaml.YamlConfiguration;
import com.hotels.styx.infrastructure.configuration.yaml.YamlConfigurationFormat;
import com.hotels.styx.proxy.ProxyServerConfig;
import com.hotels.styx.server.HttpConnectorConfig;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StyxConfig
implements Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(StyxConfig.class);
    private static final String VALIDATE_SERVER_CONFIG_PROPERTY = "validateServerConfig";
    public static final String NO_JVM_ROUTE_SET = "noJvmRouteSet";
    private final Configuration configuration;
    private final ProxyServerConfig proxyServerConfig;
    private final AdminServerConfig adminServerConfig;
    private final StyxHeaderConfig styxHeaderConfig;

    public StyxConfig() {
        this(EMPTY_CONFIGURATION);
    }

    public StyxConfig(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        this.adminServerConfig = this.get("admin", AdminServerConfig.class).orElseGet(AdminServerConfig::new);
        this.proxyServerConfig = this.get("proxy", ProxyServerConfig.class).orElseGet(ProxyServerConfig::new);
        this.styxHeaderConfig = this.get("styxHeaders", StyxHeaderConfig.class).orElseGet(StyxHeaderConfig::new);
    }

    public <T> Optional<T> get(String key, Class<T> tClass) {
        return this.configuration.get(key, tClass);
    }

    public <X> X as(Class<X> type) {
        return (X)this.configuration.as(type);
    }

    public Optional<String> get(String key) {
        return this.get(key, String.class);
    }

    public StyxHeaderConfig styxHeaderConfig() {
        return this.styxHeaderConfig;
    }

    public ProxyServerConfig proxyServerConfig() {
        return this.proxyServerConfig;
    }

    public AdminServerConfig adminServerConfig() {
        return this.adminServerConfig;
    }

    public int port() {
        return ((HttpConnectorConfig)this.proxyServerConfig().httpConnectorConfig().get()).port();
    }

    public Optional<String> applicationsConfigurationPath() {
        return this.get("originsFile", String.class);
    }

    public Iterable<Resource> versionFiles(StartupConfig startupConfig) {
        Path rootPath = startupConfig.styxHome();
        String versionFilesAsString = this.get("userDefined.versionFiles", String.class).orElseGet(() -> rootPath.resolve("styx-version.txt").toString());
        Iterable<String> versionFiles = StyxConfig.versionFiles(versionFilesAsString);
        return StreamSupport.stream(versionFiles.spliterator(), false).map(ResourceFactory::newResource).collect(Collectors.toList());
    }

    public static StyxConfig fromYaml(String yamlText) {
        return StyxConfig.fromYaml(yamlText, !StyxConfig.skipServerConfigValidation());
    }

    public static StyxConfig fromYaml(String yamlText, boolean validateConfiguration) {
        YamlConfiguration configuration = StyxConfig.loadYamlConfiguration(yamlText);
        if (validateConfiguration) {
            ServerConfigSchema.validateServerConfiguration(configuration).ifPresent(it -> {
                throw new SchemaValidationException(it);
            });
        } else {
            LOG.warn("Styx config validation disabled");
        }
        return new StyxConfig(configuration);
    }

    public static StyxConfig defaultConfig() {
        return new StyxConfig();
    }

    public String toString() {
        return this.configuration.toString();
    }

    private static boolean skipServerConfigValidation() {
        String validate = System.getProperty(VALIDATE_SERVER_CONFIG_PROPERTY, "yes");
        return "n".equals(validate) || "no".equals(validate);
    }

    private static Iterable<String> versionFiles(String versionFilesAsString) {
        return Arrays.stream(versionFilesAsString.split(",")).filter(Strings::isNotEmpty).map(String::trim).collect(Collectors.toList());
    }

    private static YamlConfiguration loadYamlConfiguration(String yaml) {
        return new ConfigurationParser.Builder<YamlConfiguration>().format(YamlConfigurationFormat.YAML).overrides(System.getProperties()).build().parse(ConfigurationSource.configSource(yaml));
    }
}

