/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.BuiltInInterceptors;
import com.hotels.styx.Environment;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.spi.Registry;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.infrastructure.MemoryBackedRegistry;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.StaticPipelineFactory;
import com.hotels.styx.routing.config.Builtins;
import com.hotels.styx.routing.config.RoutingConfigParser;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.handlers.HttpInterceptorPipeline;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StyxPipelineFactory {
    private final RoutingObjectFactory.Context builtinRoutingObjects;
    private final Environment environment;
    private final Map<String, StyxService> services;
    private final List<NamedPlugin> plugins;
    private final NettyExecutor executor;

    public StyxPipelineFactory(RoutingObjectFactory.Context builtinRoutingObjects, Environment environment, Map<String, StyxService> services, List<NamedPlugin> plugins, NettyExecutor executor) {
        this.builtinRoutingObjects = Objects.requireNonNull(builtinRoutingObjects);
        this.environment = Objects.requireNonNull(environment);
        this.services = Objects.requireNonNull(services);
        this.plugins = Objects.requireNonNull(plugins);
        this.executor = Objects.requireNonNull(executor);
    }

    public HttpHandler create() {
        boolean requestTracking = this.environment.configuration().get("requestTracking", Boolean.class).orElse(false);
        return new HttpInterceptorPipeline(BuiltInInterceptors.internalStyxInterceptors(this.environment.styxConfig(), this.environment.httpMessageFormatter()), this.configuredPipeline(this.builtinRoutingObjects), requestTracking);
    }

    private RoutingObject configuredPipeline(RoutingObjectFactory.Context routingObjectFactoryContext) {
        boolean requestTracking = this.environment.configuration().get("requestTracking", Boolean.class).orElse(false);
        Optional<JsonNode> rootHandlerNode = this.environment.configuration().get("httpPipeline", JsonNode.class);
        if (rootHandlerNode.isPresent()) {
            return Builtins.build((List<String>)ImmutableList.of((Object)"httpPipeline"), routingObjectFactoryContext, RoutingConfigParser.toRoutingConfigNode(rootHandlerNode.get()));
        }
        Registry registry = (Registry)this.services.get("backendServiceRegistry");
        return new StaticPipelineFactory(this.environment, (Registry<BackendService>)(registry != null ? registry : new MemoryBackedRegistry()), this.plugins, this.executor, requestTracking).build();
    }
}

