/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx;

import com.google.common.base.Stopwatch;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.hotels.styx.Environment;
import com.hotels.styx.InetServer;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.ProxyConnectorFactory;
import com.hotels.styx.ResponseInfoFormat;
import com.hotels.styx.ServiceProviderMonitor;
import com.hotels.styx.StartupConfig;
import com.hotels.styx.StyxConfig;
import com.hotels.styx.StyxObjectRecord;
import com.hotels.styx.StyxPipelineFactory;
import com.hotels.styx.StyxServers;
import com.hotels.styx.admin.AdminServerBuilder;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.Resource;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.spi.AbstractStyxService;
import com.hotels.styx.api.extension.service.spi.Registry;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.config.schema.SchemaValidationException;
import com.hotels.styx.infrastructure.MemoryBackedRegistry;
import com.hotels.styx.infrastructure.logging.LOGBackConfigurer;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import com.hotels.styx.server.ConnectorConfig;
import com.hotels.styx.server.netty.NettyServerBuilder;
import com.hotels.styx.server.netty.ServerConnector;
import com.hotels.styx.startup.CoreMetrics;
import com.hotels.styx.startup.StyxServerComponents;
import io.netty.util.ResourceLeakDetector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StyxServer
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(StyxServer.class);
    private final InetServer httpServer;
    private final InetServer httpsServer;
    private final InetServer adminServer;
    private final ServiceManager phase1Services;
    private final ServiceManager phase2Services;
    private final Stopwatch stopwatch;
    private final StyxServerComponents components;
    private NettyExecutor proxyBossExecutor;
    private NettyExecutor proxyWorkerExecutor;

    public static void main(String[] args) {
        try {
            StyxServer styxServer = StyxServer.createStyxServer(args);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> styxServer.stopAsync().awaitTerminated()));
            styxServer.startAsync().awaitRunning();
        }
        catch (SchemaValidationException cause) {
            LOG.error(cause.getMessage());
            System.exit(2);
        }
        catch (Throwable cause) {
            LOG.error("Error in Styx server startup.", cause);
            System.exit(1);
        }
    }

    private static StyxServer createStyxServer(String[] args) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        StartupConfig startupConfig = StyxServer.parseStartupConfig(args);
        LOG.info("Styx home={}", (Object)startupConfig.styxHome());
        LOG.info("Styx configFileLocation={}", (Object)startupConfig.configFileLocation());
        LOG.info("Styx logConfigLocation={}", (Object)startupConfig.logConfigLocation());
        StyxServerComponents components = new StyxServerComponents.Builder().styxConfig(StyxServer.parseConfiguration(startupConfig)).startupConfig(startupConfig).loggingSetUp(environment -> StyxServer.activateLogbackConfigurer(startupConfig)).build();
        return new StyxServer(components, stopwatch);
    }

    private static void activateLogbackConfigurer(StartupConfig startupConfig) {
        if (!StyxServer.isUnitTestingMode()) {
            LOGBackConfigurer.initLogging(StyxServer.logConfigLocation(startupConfig), true);
        }
    }

    private static boolean isUnitTestingMode() {
        return Optional.ofNullable(System.getProperty("UNIT_TESTING_MODE")).filter(value -> !value.isEmpty()).isPresent();
    }

    private static String logConfigLocation(StartupConfig startupConfig) {
        return Paths.get(startupConfig.logConfigLocation().url().getFile(), new String[0]).toString();
    }

    @NotNull
    private static StyxConfig parseConfiguration(StartupConfig startupConfig) {
        String yaml = StyxServer.readYaml(startupConfig.configFileLocation());
        try {
            return StyxConfig.fromYaml(yaml);
        }
        catch (SchemaValidationException e) {
            String errorFormat = "Styx server failed to start due to configuration error in file [%s]: %s";
            throw new SchemaValidationException(String.format(errorFormat, startupConfig.configFileLocation(), e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readYaml(Resource resource) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.inputStream()));){
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StyxServer(StyxServerComponents config) {
        this(config, null);
    }

    public StyxServer(StyxServerComponents components, Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
        this.components = components;
        CoreMetrics.registerCoreMetrics(components.environment().buildInfo(), components.environment().metricRegistry());
        HttpHandler handlerForOldProxyServer = new StyxPipelineFactory(components.routingObjectFactoryContext(), components.environment(), components.services(), components.plugins(), components.clientExecutor()).create();
        ArrayList<Service> services = new ArrayList<Service>();
        this.adminServer = StyxServer.createAdminServer(components);
        services.add(StyxServers.toGuavaService((StyxService)this.adminServer));
        services.add(StyxServers.toGuavaService((StyxService)new PluginsManager("Styx-Plugins-Manager", components)));
        services.add(StyxServers.toGuavaService(new ServiceProviderMonitor<StyxObjectRecord<StyxService>>("Styx-Service-Monitor", components.servicesDatabase())));
        components.services().values().forEach(it -> services.add(StyxServers.toGuavaService(it)));
        this.phase1Services = new ServiceManager(services);
        StyxConfig styxConfig = components.environment().configuration();
        this.proxyBossExecutor = NettyExecutor.create((String)"Proxy-Boss", (int)styxConfig.proxyServerConfig().bossThreadsCount());
        this.proxyWorkerExecutor = NettyExecutor.create((String)"Proxy-Worker", (int)styxConfig.proxyServerConfig().workerThreadsCount());
        this.httpServer = styxConfig.proxyServerConfig().httpConnectorConfig().map(it -> this.httpServer(components, (ConnectorConfig)it, handlerForOldProxyServer)).orElse(null);
        this.httpsServer = styxConfig.proxyServerConfig().httpsConnectorConfig().map(it -> this.httpServer(components, (ConnectorConfig)it, handlerForOldProxyServer)).orElse(null);
        ArrayList<Service> services2 = new ArrayList<Service>();
        Optional.ofNullable(this.httpServer).map(StyxServers::toGuavaService).ifPresent(services2::add);
        Optional.ofNullable(this.httpsServer).map(StyxServers::toGuavaService).ifPresent(services2::add);
        services2.add(StyxServers.toGuavaService(new ServiceProviderMonitor<StyxObjectRecord<InetServer>>("Styx-Server-Monitor", components.serversDatabase())));
        this.phase2Services = new ServiceManager(services2);
    }

    public InetSocketAddress serverAddress(String name) {
        return this.components.serversDatabase().get(name).map(it -> ((InetServer)it.component4()).inetAddress()).orElse(null);
    }

    public InetSocketAddress proxyHttpAddress() {
        return Optional.ofNullable(this.httpServer).map(InetServer::inetAddress).orElse(null);
    }

    public InetSocketAddress proxyHttpsAddress() {
        return Optional.ofNullable(this.httpsServer).map(InetServer::inetAddress).orElse(null);
    }

    public InetSocketAddress adminHttpAddress() {
        return this.adminServer.inetAddress();
    }

    private InetServer httpServer(StyxServerComponents components, ConnectorConfig connectorConfig, HttpHandler styxDataPlane) {
        Environment environment = components.environment();
        CharSequence styxInfoHeaderName = environment.configuration().styxHeaderConfig().styxInfoHeaderName();
        ResponseInfoFormat responseInfoFormat = new ResponseInfoFormat(environment);
        ServerConnector proxyConnector = new ProxyConnectorFactory(environment.configuration().proxyServerConfig(), environment.metricRegistry(), environment.errorListener(), environment.configuration().get("url.encoding.unwiseCharactersToEncode").orElse(""), (builder, request) -> builder.header(styxInfoHeaderName, (Object)responseInfoFormat.format(request)), environment.configuration().get("requestTracking", Boolean.class).orElse(false), environment.httpMessageFormatter(), environment.configuration().styxHeaderConfig().originIdHeaderName()).create(connectorConfig);
        return NettyServerBuilder.newBuilder().setMetricsRegistry(environment.metricRegistry()).bossExecutor(this.proxyBossExecutor).workerExecutor(this.proxyWorkerExecutor).setProtocolConnector(proxyConnector).handler(styxDataPlane).build();
    }

    private static void initialisePlugins(Iterable<NamedPlugin> plugins) {
        int exceptions = 0;
        for (NamedPlugin plugin : plugins) {
            try {
                plugin.styxStarting();
            }
            catch (Exception e) {
                ++exceptions;
                LOG.error("Error starting plugin '{}'", (Object)plugin.name(), (Object)e);
            }
        }
        if (exceptions > 0) {
            throw new RuntimeException(String.format("%s plugins failed to start", exceptions));
        }
    }

    private static StartupConfig parseStartupConfig(String[] args) {
        StartupConfig startupConfig = null;
        switch (args.length) {
            case 0: {
                startupConfig = StartupConfig.load();
                break;
            }
            default: {
                System.err.println(String.format("USAGE: java %s", StyxServer.class.getName()));
                System.exit(1);
            }
        }
        return startupConfig;
    }

    protected void doStart() {
        this.printBanner();
        CompletableFuture.runAsync(() -> {
            this.phase1Services.addListener((ServiceManager.Listener)new Phase1ServerStatusListener(this));
            this.phase1Services.startAsync().awaitHealthy();
            this.phase2Services.addListener((ServiceManager.Listener)new Phase2ServerStatusListener(this));
            this.phase2Services.startAsync();
        });
    }

    protected void doStop() {
        this.phase2Services.stopAsync().awaitStopped();
        this.proxyBossExecutor.shut();
        this.proxyWorkerExecutor.shut();
        this.components.executors().entrySet().forEach(entry -> ((NettyExecutor)((StyxObjectRecord)entry.getValue()).component4()).shut());
        this.phase1Services.stopAsync().awaitStopped();
        LOGBackConfigurer.shutdownLogging(true);
    }

    private void printBanner() {
        try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/banner.txt"));){
            LOG.info(String.format("Starting styx %n{}", new Object[0]), (Object)CharStreams.toString((Readable)reader));
        }
        catch (IOException | IllegalArgumentException ignored) {
            LOG.debug("Could not display banner: ", (Throwable)ignored);
            LOG.info("Starting styx");
        }
    }

    private static InetServer createAdminServer(StyxServerComponents components) {
        Registry registry = (Registry)components.services().get("backendServiceRegistry");
        return new AdminServerBuilder(components).backendServicesRegistry((Registry<BackendService>)(registry != null ? registry : new MemoryBackedRegistry())).build();
    }

    static {
        LOG.debug("Real -Dio.netty.leakDetectionLevel = " + System.getProperty("io.netty.leakDetectionLevel"));
        if (System.getProperty("io.netty.leakDetectionLevel") == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
        LOG.debug("Real resource leak detection level = {}", (Object)ResourceLeakDetector.getLevel());
    }

    private class Phase1ServerStatusListener
    extends ServiceManager.Listener {
        private final StyxServer styxServer;

        Phase1ServerStatusListener(StyxServer styxServer2) {
            this.styxServer = styxServer2;
        }

        public void healthy() {
            LOG.info("Started phase 1 services");
        }

        public void failure(Service service) {
            LOG.error("Failed to start service={} cause={}", (Object)service, (Object)service.failureCause());
            this.styxServer.notifyFailed(service.failureCause());
        }

        public void stopped() {
            LOG.info("Stopped phase 1 services.");
            this.styxServer.notifyStopped();
        }
    }

    private class Phase2ServerStatusListener
    extends ServiceManager.Listener {
        private final StyxServer styxServer;

        Phase2ServerStatusListener(StyxServer styxServer2) {
            this.styxServer = styxServer2;
        }

        public void healthy() {
            this.styxServer.notifyStarted();
            if (StyxServer.this.stopwatch == null) {
                LOG.info("Started Styx server");
            } else {
                LOG.info("Started Styx server in {} ms", (Object)StyxServer.this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
            }
        }

        public void failure(Service service) {
            LOG.error("Failed to start service={} cause={}", (Object)service, (Object)service.failureCause());
            this.styxServer.notifyFailed(service.failureCause());
        }

        public void stopped() {
            LOG.info("Stopped phase 2 services");
        }
    }

    private class PluginsManager
    extends AbstractStyxService {
        private final StyxServerComponents components;

        public PluginsManager(String name, StyxServerComponents components) {
            super(name);
            this.components = components;
        }

        public CompletableFuture<Void> startService() {
            return CompletableFuture.runAsync(() -> StyxServer.initialisePlugins(this.components.plugins()));
        }

        protected CompletableFuture<Void> stopService() {
            return CompletableFuture.runAsync(() -> {
                for (NamedPlugin plugin : this.components.plugins()) {
                    try {
                        plugin.styxStopping();
                    }
                    catch (Exception e) {
                        LOG.error("Error stopping plugin '{}'", (Object)plugin.name(), (Object)e);
                    }
                }
            });
        }
    }
}

