/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOG = LoggerFactory.getLogger(Version.class);
    private static final Pattern VERSION_FORMAT = Pattern.compile("(\\d+)\\.(\\d+)[-.](\\d+).*");
    private final String releaseTag;

    public static Version newVersion() {
        return new Version();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version readVersionFrom(String versionPath) {
        try (InputStreamReader reader = new InputStreamReader(Version.class.getResourceAsStream(versionPath));){
            Version version = (Version)new ObjectMapper().readValue((Reader)reader, Version.class);
            return version;
        }
        catch (Exception e) {
            LOG.warn("error reading  [{}]. {}", (Object)versionPath, (Object)e);
            return new Version();
        }
    }

    private Version() {
        this.releaseTag = "STYX-dev.0.0";
    }

    @JsonCreator
    public Version(@JsonProperty(value="release.tag") String releaseTag) {
        this.releaseTag = releaseTag;
    }

    @JsonProperty(value="release.tag")
    public String releaseTag() {
        return this.releaseTag;
    }

    public String releaseVersion() {
        int firstDot = this.releaseTag.indexOf(46);
        if (firstDot == -1 || firstDot == this.releaseTag.length() - 1) {
            return this.releaseTag;
        }
        return this.releaseTag.substring(firstDot + 1);
    }

    public Optional<Integer> buildNumber() {
        String releaseVersion = this.releaseVersion();
        Optional<String> buildNumberAsString = this.extractFinalInt(releaseVersion);
        return buildNumberAsString.flatMap(this::parseInteger);
    }

    private Optional<String> extractFinalInt(String versionString) {
        Matcher m = VERSION_FORMAT.matcher(versionString);
        if (!m.matches()) {
            return Optional.empty();
        }
        return Optional.of(m.group(3));
    }

    private Optional<Integer> parseInteger(String string) {
        try {
            return Optional.of(Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public String toString() {
        return new StringBuilder(32).append(this.getClass().getSimpleName()).append("{releaseTag=").append(this.releaseTag).append('}').toString();
    }

    public int hashCode() {
        return Objects.hash(this.releaseTag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return Objects.equals(this.releaseTag, other.releaseTag);
    }
}

