/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin;

import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import com.hotels.styx.Environment;
import com.hotels.styx.InetServer;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.StartupConfig;
import com.hotels.styx.StyxConfig;
import com.hotels.styx.StyxObjectRecord;
import com.hotels.styx.admin.AdminServerConfig;
import com.hotels.styx.admin.dashboard.DashboardData;
import com.hotels.styx.admin.dashboard.DashboardDataSupplier;
import com.hotels.styx.admin.handlers.CurrentRequestsHandler;
import com.hotels.styx.admin.handlers.IndexHandler;
import com.hotels.styx.admin.handlers.JVMMetricsHandler;
import com.hotels.styx.admin.handlers.JsonHandler;
import com.hotels.styx.admin.handlers.LoggingConfigurationHandler;
import com.hotels.styx.admin.handlers.MetricsHandler;
import com.hotels.styx.admin.handlers.OriginsHandler;
import com.hotels.styx.admin.handlers.OriginsInventoryHandler;
import com.hotels.styx.admin.handlers.PingHandler;
import com.hotels.styx.admin.handlers.PluginListHandler;
import com.hotels.styx.admin.handlers.PluginToggleHandler;
import com.hotels.styx.admin.handlers.ProviderRoutingHandler;
import com.hotels.styx.admin.handlers.RoutingObjectHandler;
import com.hotels.styx.admin.handlers.ServiceProviderHandler;
import com.hotels.styx.admin.handlers.StartupConfigHandler;
import com.hotels.styx.admin.handlers.StyxConfigurationHandler;
import com.hotels.styx.admin.handlers.ThreadsHandler;
import com.hotels.styx.admin.handlers.UptimeHandler;
import com.hotels.styx.admin.handlers.VersionTextHandler;
import com.hotels.styx.admin.tasks.OriginsCommandHandler;
import com.hotels.styx.admin.tasks.OriginsReloadCommandHandler;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpMethod;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.spi.Registry;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.common.http.handler.HttpAggregator;
import com.hotels.styx.common.http.handler.HttpMethodFilteringHandler;
import com.hotels.styx.common.http.handler.StaticBodyHttpHandler;
import com.hotels.styx.routing.RoutingObjectRecord;
import com.hotels.styx.routing.config.ConfigVersionResolver;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.db.StyxObjectStore;
import com.hotels.styx.server.AdminHttpRouter;
import com.hotels.styx.server.ConnectorConfig;
import com.hotels.styx.server.handlers.ClassPathResourceHandler;
import com.hotels.styx.server.netty.NettyServerBuilder;
import com.hotels.styx.server.netty.WebServerConnectorFactory;
import com.hotels.styx.server.track.CurrentRequestTracker;
import com.hotels.styx.startup.StyxServerComponents;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AdminServerBuilder.class);
    private static final int MEGABYTE = 0x100000;
    private final Environment environment;
    private final Configuration configuration;
    private final RoutingObjectFactory.Context routingObjectFactoryContext;
    private final StyxObjectStore<RoutingObjectRecord> routeDatabase;
    private final StyxObjectStore<StyxObjectRecord<StyxService>> providerDatabase;
    private final StyxObjectStore<StyxObjectRecord<InetServer>> serverDatabase;
    private final StartupConfig startupConfig;
    private Registry<BackendService> backendServicesRegistry;

    public AdminServerBuilder(StyxServerComponents serverComponents) {
        this.environment = Objects.requireNonNull(serverComponents.environment());
        this.routeDatabase = Objects.requireNonNull(serverComponents.routeDatabase());
        this.routingObjectFactoryContext = Objects.requireNonNull(serverComponents.routingObjectFactoryContext());
        this.providerDatabase = Objects.requireNonNull(serverComponents.servicesDatabase());
        this.configuration = this.environment.configuration();
        this.startupConfig = serverComponents.startupConfig();
        this.serverDatabase = Objects.requireNonNull(serverComponents.serversDatabase());
    }

    public AdminServerBuilder backendServicesRegistry(Registry<BackendService> backendServicesRegistry) {
        this.backendServicesRegistry = Objects.requireNonNull(backendServicesRegistry);
        return this;
    }

    public InetServer build() {
        LOG.info("event bus that will be used is {}", (Object)this.environment.eventBus());
        StyxConfig styxConfig = this.environment.configuration();
        AdminServerConfig adminServerConfig = styxConfig.adminServerConfig();
        NettyExecutor bossExecutor2 = NettyExecutor.create((String)"Admin-Boss", (int)adminServerConfig.bossThreadsCount());
        NettyExecutor workerExecutor2 = NettyExecutor.create((String)"Admin-Worker", (int)adminServerConfig.workerThreadsCount());
        NettyServerBuilder builder = NettyServerBuilder.newBuilder().setMetricsRegistry(this.environment.metricRegistry()).bossExecutor(bossExecutor2).workerExecutor(workerExecutor2).handler(this.adminEndpoints(styxConfig, this.startupConfig)).shutdownAction(() -> {
            bossExecutor2.shut();
            workerExecutor2.shut();
        });
        adminServerConfig.httpConnectorConfig().ifPresent(it -> builder.setProtocolConnector(new WebServerConnectorFactory().create((ConnectorConfig)it)));
        return builder.build();
    }

    private HttpHandler adminEndpoints(StyxConfig styxConfig, StartupConfig startupConfig) {
        Optional<Duration> metricsCacheExpiration = styxConfig.adminServerConfig().metricsCacheExpiration();
        AdminHttpRouter httpRouter = new AdminHttpRouter();
        httpRouter.aggregate("/", (WebServiceHandler)new IndexHandler(AdminServerBuilder.indexLinkPaths(styxConfig)));
        httpRouter.aggregate("/version.txt", (WebServiceHandler)new VersionTextHandler(styxConfig.versionFiles(startupConfig)));
        httpRouter.aggregate("/admin", (WebServiceHandler)new IndexHandler(AdminServerBuilder.indexLinkPaths(styxConfig)));
        httpRouter.aggregate("/admin/uptime", new UptimeHandler(this.environment.metricRegistry()));
        httpRouter.aggregate("/admin/ping", (WebServiceHandler)new PingHandler());
        httpRouter.aggregate("/admin/threads", (WebServiceHandler)new ThreadsHandler());
        httpRouter.aggregate("/admin/current_requests", (WebServiceHandler)new CurrentRequestsHandler(CurrentRequestTracker.INSTANCE));
        MetricsHandler metricsHandler = new MetricsHandler(this.environment.metricRegistry(), metricsCacheExpiration);
        httpRouter.aggregate("/admin/metrics", metricsHandler);
        httpRouter.aggregate("/admin/metrics/", metricsHandler);
        httpRouter.aggregate("/admin/configuration", new StyxConfigurationHandler(this.configuration));
        httpRouter.aggregate("/admin/jvm", (WebServiceHandler)new JVMMetricsHandler(this.environment.metricRegistry(), metricsCacheExpiration));
        httpRouter.aggregate("/admin/configuration/logging", new LoggingConfigurationHandler(startupConfig.logConfigLocation()));
        httpRouter.aggregate("/admin/configuration/startup", (WebServiceHandler)new StartupConfigHandler(startupConfig));
        RoutingObjectHandler routingObjectHandler = new RoutingObjectHandler(this.routeDatabase, this.routingObjectFactoryContext);
        httpRouter.aggregate("/admin/routing", routingObjectHandler);
        httpRouter.aggregate("/admin/routing/", routingObjectHandler);
        ServiceProviderHandler serviceProvideHandler = new ServiceProviderHandler(this.providerDatabase);
        httpRouter.aggregate("/admin/service/providers", serviceProvideHandler);
        httpRouter.aggregate("/admin/service/provider/", serviceProvideHandler);
        if (ConfigVersionResolver.configVersion(styxConfig) == ConfigVersionResolver.Version.ROUTING_CONFIG_V1) {
            httpRouter.aggregate("/admin/dashboard/data.json", (WebServiceHandler)this.dashboardDataHandler(styxConfig));
            httpRouter.aggregate("/admin/dashboard/", (WebServiceHandler)new ClassPathResourceHandler("/admin/dashboard/"));
        }
        httpRouter.aggregate("/admin/origins/status", (WebServiceHandler)new OriginsInventoryHandler(this.environment.eventBus()));
        httpRouter.aggregate("/admin/configuration/origins", (WebServiceHandler)new OriginsHandler(this.backendServicesRegistry));
        httpRouter.aggregate("/admin/tasks/origins/reload", (WebServiceHandler)new HttpMethodFilteringHandler(HttpMethod.POST, (WebServiceHandler)new OriginsReloadCommandHandler(this.backendServicesRegistry)));
        httpRouter.aggregate("/admin/tasks/origins", (WebServiceHandler)new HttpMethodFilteringHandler(HttpMethod.POST, (WebServiceHandler)new OriginsCommandHandler(this.environment.eventBus())));
        httpRouter.aggregate("/admin/tasks/plugin/", new PluginToggleHandler(this.environment.plugins()));
        this.environment.plugins().forEach(namedPlugin -> AdminServerBuilder.extensionEndpoints("plugins", namedPlugin.name(), namedPlugin.adminInterfaceHandlers()).forEach(route -> httpRouter.stream(route.path(), route.handler())));
        httpRouter.aggregate("/admin/plugins", new PluginListHandler(this.environment.plugins()));
        ProviderRoutingHandler providerHandler = new ProviderRoutingHandler("/admin/providers", this.providerDatabase);
        httpRouter.aggregate("/admin/providers", providerHandler);
        httpRouter.aggregate("/admin/providers/", providerHandler);
        ProviderRoutingHandler serverHandler = new ProviderRoutingHandler("/admin/servers", this.serverDatabase);
        httpRouter.aggregate("/admin/servers", serverHandler);
        httpRouter.aggregate("/admin/servers/", serverHandler);
        return httpRouter;
    }

    private JsonHandler<DashboardData> dashboardDataHandler(StyxConfig styxConfig) {
        return new JsonHandler<DashboardData>(new DashboardDataSupplier(this.backendServicesRegistry, this.environment, styxConfig), Optional.of(Duration.ofSeconds(10L)), new Module[]{new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false)});
    }

    private static Iterable<IndexHandler.Link> indexLinkPaths(StyxConfig styxConfig) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)IndexHandler.Link.link("version.txt", "/version.txt"));
        builder.add((Object)IndexHandler.Link.link("uptime", "/admin/uptime"));
        builder.add((Object)IndexHandler.Link.link("Ping", "/admin/ping"));
        builder.add((Object)IndexHandler.Link.link("Threads", "/admin/threads"));
        builder.add((Object)IndexHandler.Link.link("Current Requests", "/admin/current_requests?withStackTrace=true"));
        builder.add((Object)IndexHandler.Link.link("Metrics", "/admin/metrics?pretty"));
        builder.add((Object)IndexHandler.Link.link("Configuration", "/admin/configuration?pretty"));
        builder.add((Object)IndexHandler.Link.link("Log Configuration", "/admin/configuration/logging"));
        builder.add((Object)IndexHandler.Link.link("Startup Configuration", "/admin/configuration/startup"));
        builder.add((Object)IndexHandler.Link.link("JVM", "/admin/jvm?pretty"));
        builder.add((Object)IndexHandler.Link.link("Plugins", "/admin/plugins"));
        builder.add((Object)IndexHandler.Link.link("Providers", "/admin/providers"));
        if (ConfigVersionResolver.configVersion(styxConfig) == ConfigVersionResolver.Version.ROUTING_CONFIG_V1) {
            builder.add((Object)IndexHandler.Link.link("Dashboard", "/admin/dashboard/index.html")).add((Object)IndexHandler.Link.link("Origins Status", "/admin/origins/status?pretty")).add((Object)IndexHandler.Link.link("Origins Configuration", "/admin/configuration/origins?pretty"));
        }
        return builder.build().stream().sorted().collect(Collectors.toList());
    }

    private static List<Route> extensionEndpoints(String root, String name, Map<String, HttpHandler> endpoints) {
        List<AdminEndpointRoute> routes = AdminServerBuilder.extensionAdminEndpointRoutes(root, name, endpoints);
        List<IndexHandler.Link> endpointLinks = routes.stream().map(AdminEndpointRoute::link).collect(Collectors.toList());
        Object handler = endpointLinks.isEmpty() ? new StaticBodyHttpHandler(MediaType.HTML_UTF_8, String.format("This plugin (%s) does not expose any admin interfaces", name)) : new IndexHandler(endpointLinks);
        Route indexRoute = new Route(AdminServerBuilder.adminPath(root, name), (HttpHandler)new HttpAggregator(0x100000, (WebServiceHandler)handler));
        return AdminServerBuilder.concatenate(indexRoute, routes);
    }

    private static <T> List<T> concatenate(T item, List<? extends T> items) {
        ArrayList<T> list = new ArrayList<T>(items.size() + 1);
        list.add(item);
        list.addAll(items);
        return list;
    }

    public static String adminPath(String root, String name) {
        return String.format("/admin/%s/%s", root, name);
    }

    public static String adminEndpointPath(String root, String name, String relativePath) {
        return AdminServerBuilder.adminPath(root, name) + "/" + AdminServerBuilder.dropFirstForwardSlash(relativePath);
    }

    private static String dropFirstForwardSlash(String key) {
        return key.length() > 0 && key.charAt(0) == '/' ? key.substring(1) : key;
    }

    private static List<AdminEndpointRoute> extensionAdminEndpointRoutes(String root, String name, Map<String, HttpHandler> endpoints) {
        return AdminServerBuilder.mapToList(endpoints, (relativePath, handler) -> new AdminEndpointRoute(root, name, (String)relativePath, (HttpHandler)handler));
    }

    private static <K, V, T> List<T> mapToList(Map<K, V> map2, BiFunction<K, V, T> function) {
        return map2.entrySet().stream().map(entry -> function.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    private static class AdminEndpointRoute
    extends Route {
        private final String root;
        private final String name;

        AdminEndpointRoute(String root, String name, String relativePath, HttpHandler handler) {
            super(AdminServerBuilder.adminEndpointPath(root, name, relativePath), handler);
            this.root = root;
            this.name = name;
        }

        String linkLabel() {
            String relativePath = this.path().substring(AdminServerBuilder.adminPath(this.root, this.name).length() + 1);
            return this.name + ": " + AdminServerBuilder.dropFirstForwardSlash(relativePath);
        }

        IndexHandler.Link link() {
            return IndexHandler.Link.link(this.linkLabel(), this.path());
        }
    }

    private static class Route {
        private final String path;
        private final HttpHandler handler;

        Route(String path, HttpHandler handler) {
            this.path = path;
            this.handler = handler;
        }

        String path() {
            return this.path;
        }

        HttpHandler handler() {
            return this.handler;
        }
    }
}

