/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.hotels.styx.server.HttpConnectorConfig;
import com.hotels.styx.server.HttpsConnectorConfig;
import com.hotels.styx.server.netty.NettyServerConfig;
import java.time.Duration;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class AdminServerConfig
extends NettyServerConfig {
    public static final int DEFAULT_ADMIN_PORT = 9000;
    private final Optional<Duration> metricsCacheExpiration;

    public AdminServerConfig() {
        this.metricsCacheExpiration = Optional.empty();
    }

    private AdminServerConfig(Builder builder) {
        super((NettyServerConfig.Builder)builder);
        this.metricsCacheExpiration = Optional.ofNullable(builder.metricsCache).filter(cache -> ((MetricsCache)cache).enabled).map(cache -> Duration.ofMillis(((MetricsCache)cache).expirationMillis));
    }

    public Optional<Duration> metricsCacheExpiration() {
        return this.metricsCacheExpiration;
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder
    extends NettyServerConfig.Builder<Builder> {
        private MetricsCache metricsCache;

        public Builder() {
            this.httpConnectorConfig = new HttpConnectorConfig(Integer.valueOf(9000));
        }

        public Builder httpPort(int port) {
            return (Builder)super.httpPort(port);
        }

        public Builder setBossThreadsCount(Integer bossThreadsCount) {
            return (Builder)super.setBossThreadsCount(bossThreadsCount);
        }

        public Builder setWorkerThreadsCount(Integer workerThreadsCount) {
            return (Builder)super.setWorkerThreadsCount(workerThreadsCount);
        }

        public Builder setNioAcceptorBacklog(Integer nioAcceptorBacklog) {
            return (Builder)super.setNioAcceptorBacklog(nioAcceptorBacklog);
        }

        public Builder setMaxInitialLength(Integer maxInitialLength) {
            return (Builder)super.setMaxInitialLength(maxInitialLength);
        }

        public Builder setMaxHeaderSize(Integer maxHeaderSize) {
            return (Builder)super.setMaxHeaderSize(maxHeaderSize);
        }

        public Builder setMaxChunkSize(Integer maxChunkSize) {
            return (Builder)super.setMaxChunkSize(maxChunkSize);
        }

        public Builder setRequestTimeoutMs(Integer requestTimeoutMs) {
            return (Builder)super.setRequestTimeoutMs(requestTimeoutMs);
        }

        public Builder setKeepAliveTimeoutMillis(Integer keepAliveTimeoutMillis) {
            return (Builder)super.setKeepAliveTimeoutMillis(keepAliveTimeoutMillis);
        }

        public Builder setConnectors(NettyServerConfig.Connectors connectors) {
            return (Builder)super.setConnectors(connectors);
        }

        public Builder setHttpConnector(HttpConnectorConfig httpConnector) {
            return (Builder)super.setHttpConnector(httpConnector);
        }

        public Builder setHttpsConnector(HttpsConnectorConfig httpsConnector) {
            return (Builder)super.setHttpsConnector(httpsConnector);
        }

        public Builder setMaxConnectionsCount(Integer maxConnectionsCount) {
            return (Builder)super.setMaxConnectionsCount(maxConnectionsCount);
        }

        @JsonProperty(value="metricsCache")
        public Builder setMetricsCache(MetricsCache metricsCache) {
            this.metricsCache = metricsCache;
            return this;
        }

        public AdminServerConfig build() {
            return new AdminServerConfig(this);
        }
    }

    static class MetricsCache {
        private final boolean enabled;
        private final int expirationMillis;

        MetricsCache(@JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="expirationMillis") Integer expirationMillis) {
            this.enabled = Optional.ofNullable(enabled).orElse(false);
            this.expirationMillis = Optional.ofNullable(expirationMillis).orElse(10000);
        }
    }
}

