/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin;

import com.google.common.annotations.VisibleForTesting;
import com.hotels.styx.api.Clock;
import com.hotels.styx.api.Clocks;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingSupplier<E>
implements Supplier<E> {
    private static final Logger LOG = LoggerFactory.getLogger(CachingSupplier.class);
    private final Supplier<? extends E> sourceSupplier;
    private final long updateIntervalMillis;
    private final Clock clock;
    private volatile E json;
    private volatile long lastUpdateMillis;

    public CachingSupplier(Supplier<? extends E> sourceSupplier, Duration updateInterval) {
        this(sourceSupplier, updateInterval, Clocks.systemClock());
    }

    @VisibleForTesting
    public CachingSupplier(Supplier<? extends E> sourceSupplier, Duration updateInterval, Clock clock) {
        this.sourceSupplier = Objects.requireNonNull(sourceSupplier);
        this.updateIntervalMillis = updateInterval.toMillis();
        this.clock = Objects.requireNonNull(clock);
    }

    @Override
    public E get() {
        this.updateIfIntervalHasElapsed();
        return this.json;
    }

    private synchronized void updateIfIntervalHasElapsed() {
        if (this.hasUpdateIntervalElapsed()) {
            try {
                this.json = this.sourceSupplier.get();
            }
            catch (Exception e) {
                LOG.error("Error generating data", (Throwable)e);
            }
            this.lastUpdateMillis = this.clock.tickMillis();
        }
    }

    private boolean hasUpdateIntervalElapsed() {
        return this.clock.tickMillis() >= this.lastUpdateMillis + this.updateIntervalMillis;
    }
}

