/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.dashboard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.hotels.styx.Version;
import com.hotels.styx.admin.dashboard.ResponseCodeSupplier;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.api.extension.OriginsChangeListener;
import com.hotels.styx.api.extension.OriginsSnapshot;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.spi.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DashboardData {
    private final MetricRegistry metrics;
    private final Server server;
    private final Downstream downstream;
    private final String serverId;
    private final String version;
    private final EventBus eventBus;
    private final Registry<BackendService> backendServicesRegistry;

    public DashboardData(MetricRegistry metrics, Registry<BackendService> backendServicesRegistry, String serverId, Version version, EventBus eventBus) {
        this.backendServicesRegistry = Objects.requireNonNull(backendServicesRegistry);
        this.serverId = Objects.requireNonNull(serverId);
        this.metrics = Objects.requireNonNull(metrics);
        this.version = version.releaseVersion();
        this.eventBus = Objects.requireNonNull(eventBus);
        this.server = new Server();
        this.downstream = new Downstream();
    }

    @JsonProperty(value="server")
    public Server server() {
        return this.server;
    }

    @JsonProperty(value="downstream")
    public Downstream downstream() {
        return this.downstream;
    }

    @JsonProperty(value="publishTime")
    public long publishTime() {
        return System.currentTimeMillis();
    }

    void unregister() {
        this.downstream.unregister();
    }

    public final class Origin
    implements OriginsChangeListener {
        private final com.hotels.styx.api.extension.Origin origin;
        private final Supplier<Map<String, Integer>> responsesSupplier;
        private final Requests requests;
        private final ConnectionsPool connectionsPool;
        private String status = "unknown";

        private Origin(com.hotels.styx.api.extension.Origin origin) {
            this.origin = origin;
            this.connectionsPool = new ConnectionsPool();
            String prefix = String.format("origins.%s.%s.requests.response.status", origin.applicationId(), origin.id());
            this.responsesSupplier = new ResponseCodeSupplier(DashboardData.this.metrics, ResponseCodeSupplier.StatusMetricType.METER, prefix, true);
            this.requests = new Requests(String.format("origins.%s.%s", origin.applicationId(), origin.id()));
        }

        @Subscribe
        public void originsChanged(OriginsSnapshot snapshot) {
            if (snapshot.activeOrigins().contains(this.origin)) {
                this.status = "active";
            } else if (snapshot.inactiveOrigins().contains(this.origin)) {
                this.status = "inactive";
            } else if (snapshot.disabledOrigins().contains(this.origin)) {
                this.status = "disabled";
            }
        }

        @JsonProperty(value="id")
        public String id() {
            return this.origin.id().toString();
        }

        @JsonProperty(value="name")
        public String name() {
            return this.origin.id().toString();
        }

        @JsonProperty(value="responses")
        public Map<String, Integer> responses() {
            return this.responsesSupplier.get();
        }

        @JsonProperty(value="requests")
        public Requests requests() {
            return this.requests;
        }

        @JsonProperty(value="status")
        public String status() {
            return this.status;
        }

        @JsonProperty(value="connectionsPool")
        public ConnectionsPool connectionsPool() {
            return this.connectionsPool;
        }

        public final class ConnectionsPool {
            private final Gauge<Integer> availableGauge;
            private final Gauge<Integer> busyGauge;
            private final Gauge<Integer> pendingGauge;

            private ConnectionsPool() {
                String prefix = String.format("origins.%s.%s.connectionspool", Origin.this.origin.applicationId(), Origin.this.origin.id());
                SortedMap gauges = DashboardData.this.metrics.getGauges();
                this.availableGauge = (Gauge)gauges.get(prefix + ".available-connections");
                this.busyGauge = (Gauge)gauges.get(prefix + ".busy-connections");
                this.pendingGauge = (Gauge)gauges.get(prefix + ".pending-connections");
            }

            @JsonProperty(value="available")
            public int available() {
                return this.availableGauge == null ? 0 : (Integer)this.availableGauge.getValue();
            }

            @JsonProperty(value="busy")
            public int busy() {
                return this.busyGauge == null ? 0 : (Integer)this.busyGauge.getValue();
            }

            @JsonProperty(value="pending")
            public int pending() {
                return this.pendingGauge == null ? 0 : (Integer)this.pendingGauge.getValue();
            }
        }
    }

    public static final class ConnectionsPoolsAggregate {
        private final Iterable<Origin.ConnectionsPool> pools;

        private ConnectionsPoolsAggregate(Iterable<Origin.ConnectionsPool> pools) {
            this.pools = pools;
        }

        @JsonProperty(value="available")
        public int available() {
            int available = 0;
            for (Origin.ConnectionsPool pool : this.pools) {
                available += pool.available();
            }
            return available;
        }

        @JsonProperty(value="busy")
        public int busy() {
            int busy = 0;
            for (Origin.ConnectionsPool pool : this.pools) {
                busy += pool.busy();
            }
            return busy;
        }

        @JsonProperty(value="pending")
        public int pending() {
            int pending = 0;
            for (Origin.ConnectionsPool pool : this.pools) {
                pending += pool.pending();
            }
            return pending;
        }
    }

    public static final class TimerData {
        private static final double DURATION_FACTOR = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);
        private final Timer timer;
        private volatile Snapshot snapshot;

        private TimerData(Timer timer) {
            this.timer = timer;
        }

        @JsonProperty(value="p50")
        public double p50() {
            return TimerData.millis(this.snapshot.getMedian());
        }

        @JsonProperty(value="p75")
        public double p75() {
            return TimerData.millis(this.snapshot.get75thPercentile());
        }

        @JsonProperty(value="p95")
        public double p95() {
            return TimerData.millis(this.snapshot.get95thPercentile());
        }

        @JsonProperty(value="p98")
        public double p98() {
            return TimerData.millis(this.snapshot.get98thPercentile());
        }

        @JsonProperty(value="p99")
        public double p99() {
            return TimerData.millis(this.snapshot.get99thPercentile());
        }

        @JsonProperty(value="p999")
        public double p999() {
            return TimerData.millis(this.snapshot.get999thPercentile());
        }

        @JsonProperty(value="mean")
        public double mean() {
            return TimerData.millis(this.snapshot.getMean());
        }

        private static double millis(double nanos) {
            return nanos * DURATION_FACTOR;
        }

        private void updateSnapshot() {
            this.snapshot = this.timer.getSnapshot();
        }
    }

    public static final class MeterData {
        private final Meter meter;

        private MeterData(Meter meter) {
            this.meter = meter;
        }

        @JsonProperty(value="count")
        public long count() {
            return this.meter.getCount();
        }

        @JsonProperty(value="m1")
        public double m1Rate() {
            return this.meter.getOneMinuteRate();
        }

        @JsonProperty(value="m15")
        public double m15Rate() {
            return this.meter.getFifteenMinuteRate();
        }

        @JsonProperty(value="mean")
        public double meanRate() {
            return this.meter.getMeanRate();
        }
    }

    public final class Requests {
        private final MeterData successRate;
        private final MeterData errorRate;
        private final TimerData latency;
        private final TimerData timeToFirstByte;

        private Requests(String prefix) {
            this.successRate = new MeterData(DashboardData.this.metrics.meter(prefix + ".requests.success-rate"));
            this.errorRate = new MeterData(DashboardData.this.metrics.meter(prefix + ".requests.error-rate"));
            this.latency = new TimerData(DashboardData.this.metrics.timer(prefix + ".requests.latency"));
            this.timeToFirstByte = new TimerData(DashboardData.this.metrics.timer(prefix + ".requests.time-to-first-byte"));
        }

        @JsonProperty(value="successRate")
        public MeterData successRate() {
            return this.successRate;
        }

        @JsonProperty(value="errorRate")
        public MeterData errorRate() {
            return this.errorRate;
        }

        @JsonProperty(value="latency")
        public TimerData latency() {
            this.latency.updateSnapshot();
            return this.latency;
        }

        @JsonProperty(value="timeToFirstByte")
        public TimerData timeToFirstByte() {
            this.timeToFirstByte.updateSnapshot();
            return this.timeToFirstByte;
        }

        @JsonProperty(value="errorPercentage")
        public double errorPercentage() {
            double errorRate = this.errorRate().count();
            return 100.0 * (errorRate / ((double)this.successRate.count() + errorRate));
        }
    }

    public final class Backend {
        private final String id;
        private final String name;
        private final List<Origin> origin;
        private List<Origin> registeredOrigins;
        private final Supplier<Map<String, Integer>> responsesSupplier;
        private final Requests requests;
        private final List<String> status;
        private final ConnectionsPoolsAggregate connectionsPoolsAggregate;

        private Backend(BackendService application) {
            this.name = application.id().toString();
            this.id = DashboardData.this.serverId + "-" + this.name;
            this.requests = new Requests("origins." + application.id());
            this.origin = application.origins().stream().map(x$0 -> new Origin((com.hotels.styx.api.extension.Origin)x$0)).collect(Collectors.toList());
            this.registeredOrigins = new ArrayList<Origin>();
            this.origin.forEach(origin -> {
                DashboardData.this.eventBus.register(origin);
                this.registeredOrigins.add((Origin)origin);
            });
            this.status = Lists.transform(this.origin, Origin::status);
            this.connectionsPoolsAggregate = new ConnectionsPoolsAggregate(Iterables.transform(this.origin, Origin::connectionsPool));
            String prefix = String.format("origins.%s.requests.response.status", this.name);
            this.responsesSupplier = new ResponseCodeSupplier(DashboardData.this.metrics, ResponseCodeSupplier.StatusMetricType.METER, prefix, true);
        }

        void unregister() {
            this.registeredOrigins.forEach(origin -> DashboardData.this.eventBus.unregister(origin));
            this.registeredOrigins = new ArrayList<Origin>();
        }

        @JsonProperty(value="id")
        public String id() {
            return this.id;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.name;
        }

        @JsonProperty(value="responses")
        public Map<String, Integer> responses() {
            return this.responsesSupplier.get();
        }

        @JsonProperty(value="requests")
        public Requests requests() {
            return this.requests;
        }

        @JsonProperty(value="origin")
        public Collection<Origin> origins() {
            return this.origin;
        }

        @JsonProperty(value="statuses")
        public Collection<String> statuses() {
            return this.status;
        }

        @JsonProperty(value="totalConnections")
        public ConnectionsPoolsAggregate totalConnections() {
            return this.connectionsPoolsAggregate;
        }

        @VisibleForTesting
        List<String> originsStatuses() {
            return this.origins().stream().map(origin -> origin.id() + "=" + origin.status()).collect(Collectors.toList());
        }

        @VisibleForTesting
        Map<String, String> statusesByOriginId() {
            return this.origins().stream().collect(Collectors.toMap(Origin::id, Origin::status));
        }

        @VisibleForTesting
        Origin origin(String originId) {
            return this.origins().stream().filter(origin -> origin.id().equals(originId)).findFirst().get();
        }

        @VisibleForTesting
        Origin firstOrigin() {
            return this.origins().stream().findFirst().get();
        }
    }

    public final class Downstream
    implements Registry.ChangeListener<BackendService> {
        private Collection<Backend> backends = this.updateBackendsFromRegistry();
        private final Supplier<Map<String, Integer>> responsesSupplier;

        private Downstream() {
            this.responsesSupplier = new ResponseCodeSupplier(DashboardData.this.metrics, ResponseCodeSupplier.StatusMetricType.COUNTER, "origins.response.status", false);
            DashboardData.this.backendServicesRegistry.addListener((Registry.ChangeListener)this);
        }

        @JsonProperty(value="responses")
        public Map<String, Integer> responses() {
            return this.responsesSupplier.get();
        }

        @JsonProperty(value="backends")
        public Collection<Backend> backends() {
            return this.backends;
        }

        @VisibleForTesting
        Backend firstBackend() {
            return this.backends().stream().findFirst().get();
        }

        @VisibleForTesting
        List<String> backendIds() {
            return this.backends().stream().map(Backend::id).collect(Collectors.toList());
        }

        @VisibleForTesting
        Backend backend(String backendId) {
            return this.backends().stream().filter(backend -> backend.id().equals(backendId)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No origin with id %s in %s", backendId, this.backendIds())));
        }

        public void onChange(Registry.Changes<BackendService> changes) {
            this.backends = this.updateBackendsFromRegistry();
        }

        private List<Backend> updateBackendsFromRegistry() {
            this.unregister();
            return StreamSupport.stream(((Iterable)DashboardData.this.backendServicesRegistry.get()).spliterator(), false).map(x$0 -> new Backend((BackendService)x$0)).collect(Collectors.toList());
        }

        void unregister() {
            if (this.backends != null) {
                this.backends.forEach(Backend::unregister);
            }
        }
    }

    public final class Server {
        private final Gauge<String> uptimeGauge;
        private final Supplier<Map<String, Integer>> responsesSupplier;

        private Server() {
            this.uptimeGauge = (Gauge)DashboardData.this.metrics.getGauges().get("jvm.uptime.formatted");
            this.responsesSupplier = new ResponseCodeSupplier(DashboardData.this.metrics, ResponseCodeSupplier.StatusMetricType.COUNTER, "styx.response.status", false);
        }

        @JsonProperty(value="id")
        public String id() {
            return DashboardData.this.serverId;
        }

        @JsonProperty(value="version")
        public String version() {
            return DashboardData.this.version;
        }

        @JsonProperty(value="uptime")
        String uptime() {
            return this.uptimeGauge == null ? null : (String)this.uptimeGauge.getValue();
        }

        @JsonProperty(value="responses")
        public Map<String, Integer> responses() {
            return this.responsesSupplier.get();
        }
    }
}

