/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.dashboard;

import com.hotels.styx.Environment;
import com.hotels.styx.StyxConfig;
import com.hotels.styx.Version;
import com.hotels.styx.admin.dashboard.DashboardData;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.spi.Registry;
import com.hotels.styx.client.origincommands.GetOriginsInventorySnapshot;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardDataSupplier
implements Supplier<DashboardData>,
Registry.ChangeListener<BackendService> {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardDataSupplier.class);
    private volatile DashboardData data;
    private final Registry<BackendService> backendServicesRegistry;
    private final Environment environment;
    private final String jvmRouteName;
    private final Version buildInfo;

    public DashboardDataSupplier(Registry<BackendService> backendServicesRegistry, Environment environment, StyxConfig styxConfig) {
        this.backendServicesRegistry = Objects.requireNonNull(backendServicesRegistry);
        this.environment = Objects.requireNonNull(environment);
        this.jvmRouteName = styxConfig.get("jvmRouteName", String.class).orElse("noJvmRouteSet");
        this.buildInfo = environment.buildInfo();
        this.data = this.updateDashboardData(backendServicesRegistry);
        this.backendServicesRegistry.addListener((Registry.ChangeListener)this);
    }

    public void onChange(Registry.Changes<BackendService> changes) {
        LOG.info("received new services changes set {}", changes);
        this.data = this.updateDashboardData(this.backendServicesRegistry);
        this.environment.eventBus().post((Object)new GetOriginsInventorySnapshot());
    }

    private DashboardData updateDashboardData(Registry<BackendService> backendServices) {
        if (this.data != null) {
            this.data.unregister();
        }
        return new DashboardData(this.environment.metricRegistry(), backendServices, this.jvmRouteName, this.buildInfo, this.environment.eventBus());
    }

    @Override
    public DashboardData get() {
        return this.data;
    }
}

