/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.dashboard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hotels.styx.admin.support.Json;
import java.util.Objects;
import java.util.function.Supplier;

public class JsonSupplier
implements Supplier<String> {
    private final Supplier<?> objectSupplier;
    private final ObjectMapper mapper;
    private final boolean pretty;

    public static JsonSupplier create(Supplier<?> objectSupplier, Module ... modules) {
        return JsonSupplier.create(objectSupplier, false, modules);
    }

    public static JsonSupplier create(Supplier<?> objectSupplier, boolean pretty, Module ... modules) {
        return new JsonSupplier(objectSupplier, pretty, modules);
    }

    private JsonSupplier(Supplier<?> objectSupplier, boolean pretty, Module ... modules) {
        this.objectSupplier = Objects.requireNonNull(objectSupplier);
        this.pretty = pretty;
        this.mapper = new ObjectMapper();
        for (Module module : modules) {
            this.mapper.registerModule(module);
        }
    }

    @Override
    public String get() {
        return this.toJson(this.objectSupplier.get());
    }

    private String toJson(Object object) {
        try {
            if (this.pretty) {
                return this.mapper.writer(Json.PRETTY_PRINTER).writeValueAsString(object);
            }
            return this.mapper.writer().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

