/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.dashboard;

import com.codahale.metrics.Counting;
import com.codahale.metrics.MetricFilter;
import com.hotels.styx.api.MetricRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

final class ResponseCodeSupplier
implements Supplier<Map<String, Integer>> {
    private final Map<String, Integer> responseCodes = new HashMap<String, Integer>();
    private final int[] aggregates = new int[5];
    private final String[] aggregateKeys = new String[]{"1xx", "2xx", "3xx", "4xx", "5xx"};
    private final MetricRegistry metrics;
    private final StatusMetricType statusMetricType;
    private final MetricFilter prefixFilter;
    private final boolean includeNonErrorCodes;

    ResponseCodeSupplier(MetricRegistry metrics, StatusMetricType statusMetricType, String prefix, boolean includeNonErrorCodes) {
        this.metrics = Objects.requireNonNull(metrics);
        this.statusMetricType = Objects.requireNonNull(statusMetricType);
        this.includeNonErrorCodes = includeNonErrorCodes;
        Objects.requireNonNull(prefix);
        this.prefixFilter = (name, metric) -> name.startsWith(prefix);
    }

    @Override
    public Map<String, Integer> get() {
        this.resetAggregates();
        if (this.statusMetricType == StatusMetricType.COUNTER) {
            this.updateFromMetrics(this.metrics.getCounters(this.prefixFilter));
        } else if (this.statusMetricType == StatusMetricType.METER) {
            this.updateFromMetrics(this.metrics.getMeters(this.prefixFilter));
        }
        this.addAggregatesToMap(this.responseCodes);
        return this.responseCodes;
    }

    private void resetAggregates() {
        Arrays.fill(this.aggregates, 0);
    }

    private void updateFromMetrics(Map<String, ? extends Counting> metrics) {
        metrics.forEach((key, metric) -> {
            long count = metric.getCount();
            this.onMetricCount((String)key, (int)count);
        });
    }

    private void onMetricCount(String key, Integer count) {
        int lastDot = key.lastIndexOf(46);
        if (lastDot > -1 && lastDot < key.length() - 1) {
            String code = key.substring(lastDot + 1);
            this.responseCodes.put(code, count);
            this.incrementAggregates(code, count);
        }
    }

    private void incrementAggregates(String code, Integer count) {
        int codeInt;
        int index;
        if (count != null && this.isPositiveInteger(code) && (index = (codeInt = Integer.parseInt(code)) / 100 - 1) >= 0 && index < this.aggregates.length) {
            int n = index;
            this.aggregates[n] = this.aggregates[n] + count;
        }
    }

    private boolean isPositiveInteger(String code) {
        for (int i = 0; i < code.length(); ++i) {
            if (Character.isDigit(code.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void addAggregatesToMap(Map<String, Integer> map2) {
        for (int i = 0; i < this.aggregates.length; ++i) {
            int firstDigit = i + 1;
            if (!this.includeNonErrorCodes && firstDigit != 4 && firstDigit != 5) continue;
            map2.put(this.aggregateKeys[i], this.aggregates[i]);
        }
    }

    public static enum StatusMetricType {
        COUNTER,
        METER;

    }
}

