/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.google.common.net.MediaType;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.common.http.handler.BaseHttpHandler;
import com.hotels.styx.server.track.CurrentRequestTracker;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.StandardCharsets;

public class CurrentRequestsHandler
extends BaseHttpHandler {
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final CurrentRequestTracker tracker;

    public CurrentRequestsHandler(CurrentRequestTracker tracker) {
        this.tracker = tracker;
    }

    public HttpResponse doHandle(HttpRequest request, HttpInterceptor.Context context) {
        boolean withStackTrace = request.queryParam("withStackTrace").map("true"::equals).orElse(false);
        return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).disableCaching().header(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.PLAIN_TEXT_UTF_8).body(this.getCurrentRequestContent(withStackTrace), StandardCharsets.UTF_8, true).build();
    }

    private String getCurrentRequestContent(boolean withStackTrace) {
        StringBuilder sb = new StringBuilder();
        this.tracker.currentRequests().forEach(req -> {
            sb.append("[\n");
            sb.append(req.request().replaceAll(",", "\n"));
            sb.append("\n\n");
            sb.append("running for: ");
            sb.append(System.currentTimeMillis() - req.startingTimeMillies());
            sb.append("ms\n");
            if (req.isRequestSent()) {
                sb.append("\nRequest state: Waiting response from origin.\n");
            } else {
                sb.append("\nRequest state: Plugins pipeline.\n");
                sb.append("\n\nThread Info:\n");
                if (withStackTrace) {
                    sb.append(this.getThreadInfo(req.currentThread().getId()));
                } else {
                    sb.append("Name: ");
                    sb.append(req.currentThread().getName());
                    sb.append("\n");
                }
            }
            sb.append("]\n\n");
        });
        return sb.toString();
    }

    private String getThreadInfo(long threadId) {
        StringBuilder sb = new StringBuilder();
        ThreadInfo t = this.threadMXBean.getThreadInfo(threadId, Integer.MAX_VALUE);
        sb.append(String.format("\"%s\" id=%d state=%s", new Object[]{t.getThreadName(), t.getThreadId(), t.getThreadState()}));
        sb.append(this.getThreadState(t));
        if (t.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (t.isInNative()) {
            sb.append(" (running in native)");
        }
        sb.append("\n");
        if (t.getLockOwnerName() != null) {
            sb.append(String.format("     owned by %s id=%d%n", t.getLockOwnerName(), t.getLockOwnerId()));
        }
        sb.append(this.getThreadElements(t));
        sb.append("\n");
        sb.append(this.getThreadLockedSynchronizer(t));
        return sb.toString();
    }

    private String getThreadState(ThreadInfo t) {
        StringBuilder sb = new StringBuilder();
        LockInfo lock = t.getLockInfo();
        if (lock != null && t.getThreadState() != Thread.State.BLOCKED) {
            sb.append(String.format("%n    - waiting on <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName()));
            sb.append(String.format("%n    - locked <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName()));
        } else if (lock != null && t.getThreadState() == Thread.State.BLOCKED) {
            sb.append(String.format("%n    - waiting to lock <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName()));
        }
        return sb.toString();
    }

    private String getThreadLockedSynchronizer(ThreadInfo t) {
        StringBuilder sb = new StringBuilder();
        LockInfo[] locks = t.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append(String.format("    Locked synchronizers: count = %d%n", locks.length));
            for (LockInfo l : locks) {
                sb.append(String.format("      - %s%n", l));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String getThreadElements(ThreadInfo t) {
        StackTraceElement[] elements = t.getStackTrace();
        MonitorInfo[] monitors = t.getLockedMonitors();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            sb.append(String.format("    at %s%n", element));
            for (int j = 1; j < monitors.length; ++j) {
                MonitorInfo monitor = monitors[j];
                if (monitor.getLockedStackDepth() != i) continue;
                sb.append(String.format("      - locked %s%n", monitor));
            }
        }
        return sb.toString();
    }
}

