/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.google.common.net.MediaType;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.common.http.handler.BaseHttpHandler;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class IndexHandler
extends BaseHttpHandler {
    private static final String INDEX_LISTING_FORMAT_STRING = "<html><body><ol style='list-style-type: none; padding-left: 0px; margin-left: 0px;'>%s</ol></body></html>";
    private final String html;

    public IndexHandler(Iterable<Link> links) {
        this.html = IndexHandler.generateHtml(links);
    }

    private static String generateHtml(Iterable<Link> links) {
        return IndexHandler.buildIndexContent(StreamSupport.stream(links.spliterator(), false).map(Link::toString).collect(Collectors.toList()));
    }

    protected HttpResponse doHandle(HttpRequest request, HttpInterceptor.Context context) {
        return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.HTML_UTF_8.toString()).header((CharSequence)"Content-Language", (Object)"en").body(this.html, StandardCharsets.UTF_8).build();
    }

    private static String buildIndexContent(Iterable<String> links) {
        StringBuilder builder = new StringBuilder();
        for (String link : links) {
            builder.append("<li>").append(link).append("</li>");
        }
        return String.format(INDEX_LISTING_FORMAT_STRING, builder);
    }

    public static final class Link
    implements Comparable<Link> {
        private final String label;
        private final String path;

        private Link(String label, String path) {
            this.label = Objects.requireNonNull(label);
            this.path = Objects.requireNonNull(path);
        }

        public static Link link(String label, String path) {
            return new Link(label, path);
        }

        @Override
        public int compareTo(Link o) {
            int comparison = this.label.compareTo(o.label);
            if (comparison == 0) {
                return this.path.compareTo(o.path);
            }
            return comparison;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Link link = (Link)o;
            if (!this.label.equals(link.label)) {
                return false;
            }
            return this.path.equals(link.path);
        }

        public int hashCode() {
            int result2 = this.label.hashCode();
            result2 = 31 * result2 + this.path.hashCode();
            return result2;
        }

        public String toString() {
            return String.format("<a href='%s'>%s</a>", this.path, this.label);
        }
    }
}

