/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.fasterxml.jackson.databind.Module;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.MediaType;
import com.hotels.styx.admin.CachingSupplier;
import com.hotels.styx.admin.dashboard.JsonSupplier;
import com.hotels.styx.admin.handlers.json.JsonReformatter;
import com.hotels.styx.api.Clock;
import com.hotels.styx.api.Clocks;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.common.http.handler.BaseHttpHandler;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHandler<E>
extends BaseHttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHandler.class);
    private final Supplier<String> jsonSupplier;
    private final Supplier<String> prettyJsonSupplier;
    private final Supplier<String> reformatSupplier;

    public JsonHandler(E data, Optional<Duration> cacheExpiration, Module ... modules) {
        this(() -> data, cacheExpiration, modules);
    }

    public JsonHandler(Supplier<E> dataSupplier, Optional<Duration> cacheExpiration, Module ... modules) {
        this(dataSupplier, cacheExpiration, Clocks.systemClock(), modules);
    }

    @VisibleForTesting
    JsonHandler(Supplier<E> dataSupplier, Optional<Duration> cacheExpiration, Clock clock, Module ... modules) {
        if (cacheExpiration.isPresent()) {
            LOG.debug("{} instantiated with cache expiration of {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)cacheExpiration.get());
        } else {
            LOG.debug("{} instantiated with no caching", (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
        this.jsonSupplier = JsonHandler.cachedSupplier(cacheExpiration, clock, JsonSupplier.create(dataSupplier, false, modules));
        this.prettyJsonSupplier = JsonHandler.cachedSupplier(cacheExpiration, clock, JsonSupplier.create(dataSupplier, true, modules));
        this.reformatSupplier = JsonHandler.cachedSupplier(cacheExpiration, clock, () -> JsonReformatter.reformat(this.jsonSupplier.get()));
    }

    protected HttpResponse doHandle(HttpRequest request, HttpInterceptor.Context context) {
        try {
            String jsonContent = this.jsonSupplier(request).get();
            return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).disableCaching().addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.JSON_UTF_8.toString()).body(jsonContent, StandardCharsets.UTF_8).build();
        }
        catch (Exception e) {
            return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR).body(e.getMessage(), StandardCharsets.UTF_8).build();
        }
    }

    private Supplier<String> jsonSupplier(HttpRequest request) {
        if (request.queryParam("reformat").isPresent()) {
            return this.reformatSupplier;
        }
        return request.queryParam("pretty").isPresent() ? this.prettyJsonSupplier : this.jsonSupplier;
    }

    private static Supplier<String> cachedSupplier(Optional<Duration> cacheExpiration, Clock clock, Supplier<String> uncachedSupplier) {
        return cacheExpiration.map(expiration -> new CachingSupplier(uncachedSupplier, (Duration)expiration, clock)).orElse(uncachedSupplier);
    }
}

