/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.net.MediaType;
import com.hotels.styx.admin.handlers.Resources;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.Resource;
import com.hotels.styx.api.WebServiceHandler;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConfigurationHandler
implements WebServiceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingConfigurationHandler.class);
    private final Resource logConfigLocation;
    private final java.util.function.Supplier<Content> contentSupplier;

    public LoggingConfigurationHandler(Resource logConfigLocation) {
        this.logConfigLocation = Objects.requireNonNull(logConfigLocation);
        this.contentSupplier = () -> ((Supplier)Suppliers.memoizeWithExpiration(this::loadContent, (long)1L, (TimeUnit)TimeUnit.SECONDS)).get();
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        return Eventual.of((Object)this.generateResponse());
    }

    private HttpResponse generateResponse() {
        Content content = this.contentSupplier.get();
        return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).header((CharSequence)"Content-Type", (Object)content.type).header((CharSequence)"Content-Length", (Object)content.length).body(content.content, StandardCharsets.UTF_8).build();
    }

    private Content loadContent() {
        try {
            String fileContents = Resources.load(this.logConfigLocation);
            return new Content(MediaType.XML_UTF_8, fileContents);
        }
        catch (IOException e) {
            this.logException(e);
            return new Content(MediaType.PLAIN_TEXT_UTF_8, "Could not load resource='" + this.logConfigLocation + "'");
        }
    }

    private void logException(IOException e) {
        LOG.error("Could not load resource=" + this.logConfigLocation, (Throwable)e);
    }

    private static class Content {
        private final String content;
        private final String type;
        private final int length;

        Content(MediaType type, String content) {
            this.content = content;
            this.type = type.toString();
            this.length = content.getBytes((Charset)type.charset().get()).length;
        }
    }
}

