/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.hotels.styx.admin.handlers.JsonHandler;
import com.hotels.styx.admin.handlers.UrlPatternRouter;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.api.metrics.codahale.CodaHaleMetricRegistry;
import com.hotels.styx.common.MapStream;
import com.hotels.styx.infrastructure.configuration.json.mixins.CodaHaleMetricRegistryMixin;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetricsHandler
implements WebServiceHandler {
    private static final Pattern SPECIFIC_METRICS_PATH_PATTERN = Pattern.compile(".*/metrics/(.+)/?");
    private static final boolean DO_NOT_SHOW_SAMPLES = false;
    private static final String FILTER_PARAM = "filter";
    private static final String PRETTY_PRINT_PARAM = "pretty";
    private final ObjectMapper metricSerialiser = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false)).addMixIn(CodaHaleMetricRegistry.class, CodaHaleMetricRegistryMixin.class);
    private final MetricRegistry metricRegistry;
    private final UrlPatternRouter urlMatcher;

    public MetricsHandler(MetricRegistry metricRegistry, Optional<Duration> cacheExpiration) {
        this.urlMatcher = new UrlPatternRouter.Builder().get(".*/metrics", (WebServiceHandler)new RootMetricsHandler(metricRegistry, cacheExpiration, new Module[]{new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false), new FullMetricsModule()})).get(".*/metrics/.*", (request, context) -> Eventual.of((Object)this.filteredMetricResponse(request))).build();
        this.metricRegistry = metricRegistry;
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        return this.urlMatcher.handle(request, context);
    }

    private static boolean matchesRoot(String metricName, String root) {
        return root == null || metricName.equals(root) || metricName.startsWith(root + ".");
    }

    private static boolean containsSearchTerm(String name, String searchTerm) {
        return searchTerm == null || name.contains(searchTerm);
    }

    private HttpResponse filteredMetricResponse(HttpRequest request) {
        String root = Optional.of(SPECIFIC_METRICS_PATH_PATTERN.matcher(request.path())).filter(Matcher::matches).map(matcher -> matcher.group(1)).orElse(null);
        boolean prettyPrint = request.queryParam(PRETTY_PRINT_PARAM).isPresent();
        String searchTerm = request.queryParam(FILTER_PARAM).orElse(null);
        Map result2 = MapStream.stream((Map)this.metricRegistry.getMetrics()).filter((name, metric) -> MetricsHandler.matchesRoot(name, root)).toMap();
        if (result2.isEmpty()) {
            return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.NOT_FOUND).build();
        }
        return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).body(this.serialise(MapStream.stream((Map)result2).filter((name, metric) -> MetricsHandler.containsSearchTerm(name, searchTerm)).toMap(), prettyPrint), StandardCharsets.UTF_8).disableCaching().build();
    }

    private String serialise(Object object, boolean pretty) {
        ObjectWriter writer = pretty ? this.metricSerialiser.writerWithDefaultPrettyPrinter() : this.metricSerialiser.writer();
        try {
            return writer.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class FullMetricsModule
    extends SimpleModule {
        FullMetricsModule() {
            this.setMixInAnnotation(CodaHaleMetricRegistry.class, CodaHaleMetricRegistryMixin.class);
        }
    }

    private static class RootMetricsHandler
    extends JsonHandler<MetricRegistry> {
        public RootMetricsHandler(MetricRegistry data, Optional<Duration> cacheExpiration, Module ... modules) {
            super(data, cacheExpiration, modules);
        }
    }
}

