/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.net.MediaType;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.spi.Registry;
import com.hotels.styx.common.http.handler.BaseHttpHandler;
import com.hotels.styx.infrastructure.configuration.json.ObjectMappers;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class OriginsHandler
extends BaseHttpHandler {
    private final ObjectMapper mapper = ObjectMappers.addStyxMixins(new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL));
    private final Registry<BackendService> backendServicesRegistry;

    public OriginsHandler(Registry<BackendService> backendServicesRegistry) {
        this.backendServicesRegistry = Objects.requireNonNull(backendServicesRegistry, "backendServicesRegistry cannot be null");
    }

    protected HttpResponse doHandle(HttpRequest request, HttpInterceptor.Context context) {
        Iterable backendServices = (Iterable)this.backendServicesRegistry.get();
        return this.jsonResponse(backendServices, this.isPrettyPrint(request));
    }

    private HttpResponse jsonResponse(Object object, boolean prettyPrint) {
        try {
            String jsonContent = this.marshal(object, prettyPrint);
            return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).disableCaching().addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.JSON_UTF_8.toString()).body(jsonContent, StandardCharsets.UTF_8).build();
        }
        catch (JsonProcessingException e) {
            return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR).body(e.getMessage(), StandardCharsets.UTF_8).build();
        }
    }

    private String marshal(Object object, boolean prettyPrint) throws JsonProcessingException {
        return this.writer(prettyPrint).writeValueAsString(object);
    }

    private ObjectWriter writer(boolean prettyPrint) {
        return prettyPrint ? this.mapper.writerWithDefaultPrettyPrinter() : this.mapper.writer();
    }

    private boolean isPrettyPrint(HttpRequest request) {
        return request.queryParam("pretty").isPresent();
    }
}

