/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.net.MediaType;
import com.hotels.styx.admin.support.Json;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.extension.OriginsChangeListener;
import com.hotels.styx.api.extension.OriginsSnapshot;
import com.hotels.styx.client.origincommands.GetOriginsInventorySnapshot;
import com.hotels.styx.common.http.handler.BaseHttpHandler;
import com.hotels.styx.infrastructure.configuration.json.ObjectMappers;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginsInventoryHandler
extends BaseHttpHandler
implements OriginsChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(OriginsInventoryHandler.class);
    private final ObjectMapper mapper = ObjectMappers.addStyxMixins(new ObjectMapper()).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setDefaultPrettyPrinter(Json.PRETTY_PRINTER);
    private final Map<Id, OriginsSnapshot> originsInventorySnapshotMap = new ConcurrentHashMap<Id, OriginsSnapshot>();

    public OriginsInventoryHandler(EventBus eventBus) {
        eventBus.register((Object)this);
        eventBus.post((Object)new GetOriginsInventorySnapshot());
    }

    protected HttpResponse doHandle(HttpRequest request, HttpInterceptor.Context context) {
        return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.JSON_UTF_8.toString()).disableCaching().body(this.content(OriginsInventoryHandler.isPrettyPrint(request)), StandardCharsets.UTF_8).build();
    }

    private String content(boolean pretty) {
        return this.originsInventorySnapshotMap.isEmpty() ? "{}" : this.marshall(this.originsInventorySnapshotMap, pretty);
    }

    private String marshall(Map<Id, OriginsSnapshot> originsInventorySnapshotMap, boolean pretty) {
        try {
            return this.writer(pretty).writeValueAsString(originsInventorySnapshotMap);
        }
        catch (JsonProcessingException e) {
            return e.getMessage();
        }
    }

    private ObjectWriter writer(boolean prettyPrint) {
        return prettyPrint ? this.mapper.writerWithDefaultPrettyPrinter() : this.mapper.writer();
    }

    private static boolean isPrettyPrint(HttpRequest request) {
        return request.queryParam("pretty").isPresent();
    }

    @Subscribe
    public void originsChanged(OriginsSnapshot snapshot) {
        LOG.debug("received origins inventory state change {}", (Object)snapshot);
        this.originsInventorySnapshotMap.put(snapshot.appId(), snapshot);
    }
}

