/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.google.common.net.MediaType;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PluginListHandler
implements WebServiceHandler {
    private final List<NamedPlugin> plugins;

    public PluginListHandler(List<NamedPlugin> plugins) {
        this.plugins = Objects.requireNonNull(plugins);
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        Stream<NamedPlugin> enabled = this.plugins.stream().filter(NamedPlugin::enabled);
        Stream<NamedPlugin> disabled = this.plugins.stream().filter(plugin -> !plugin.enabled());
        boolean needsIncludeDisabledPlugins = this.existDisabledPlugins();
        String output = PluginListHandler.section(needsIncludeDisabledPlugins ? "Enabled" : "Loaded", enabled) + (needsIncludeDisabledPlugins ? PluginListHandler.section("Disabled", disabled) : "");
        return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).body(output, StandardCharsets.UTF_8).addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.HTML_UTF_8.toString()).build());
    }

    private static String section(String toggleState, Stream<NamedPlugin> plugins) {
        return String.format("<h3>%s</h3>", toggleState) + plugins.map(NamedPlugin::name).map(PluginListHandler::pluginLink).collect(Collectors.joining());
    }

    private static String pluginLink(String name) {
        return String.format("<a href='/admin/plugins/%s'>%s</a><br />", name, name);
    }

    private boolean existDisabledPlugins() {
        return this.plugins.stream().anyMatch(it -> !it.enabled());
    }
}

