/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpMethod;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginToggleHandler
implements WebServiceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginToggleHandler.class);
    private static final Pattern URL_PATTERN = Pattern.compile(".*/([^/]+)/enabled/?");
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final List<NamedPlugin> plugins;

    public PluginToggleHandler(List<NamedPlugin> plugins) {
        this.plugins = Objects.requireNonNull(plugins);
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        return this.getCurrentOrPutNewState(request, context).onError(cause -> PluginToggleHandler.handleErrors(cause, context));
    }

    private Eventual<HttpResponse> getCurrentOrPutNewState(HttpRequest request, HttpInterceptor.Context context) {
        if (HttpMethod.GET.equals(request.method())) {
            return this.getCurrentState(request, context);
        }
        if (HttpMethod.PUT.equals(request.method())) {
            return this.putNewState(request, context);
        }
        return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.METHOD_NOT_ALLOWED).build());
    }

    private Eventual<HttpResponse> getCurrentState(HttpRequest request, HttpInterceptor.Context context) {
        return Eventual.of((Object)request).map(this::plugin).map(PluginToggleHandler::currentState).map(state -> PluginToggleHandler.responseWith(HttpResponseStatus.OK, state.toString()));
    }

    private static PluginEnabledState currentState(NamedPlugin plugin) {
        return plugin.enabled() ? PluginEnabledState.ENABLED : PluginEnabledState.DISABLED;
    }

    private Eventual<HttpResponse> putNewState(HttpRequest request, HttpInterceptor.Context context) {
        return Eventual.of((Object)request).flatMap(this::requestedUpdate).map(PluginToggleHandler::applyUpdate);
    }

    private Eventual<RequestedUpdate> requestedUpdate(HttpRequest request) {
        return PluginToggleHandler.requestedNewState(request).map(state -> {
            NamedPlugin plugin = this.plugin(request);
            return new RequestedUpdate(plugin, (PluginEnabledState)((Object)state));
        });
    }

    private static HttpResponse applyUpdate(RequestedUpdate requestedUpdate) {
        boolean changed = requestedUpdate.apply();
        String message = PluginToggleHandler.responseMessage(requestedUpdate, changed);
        return PluginToggleHandler.responseWith(HttpResponseStatus.OK, message);
    }

    private static String responseMessage(RequestedUpdate requestedUpdate, boolean changed) {
        String message = changed ? PluginToggleHandler.wasChangedMessage(requestedUpdate) : PluginToggleHandler.wasNotChangedMessage(requestedUpdate);
        try {
            return JSON_MAPPER.writeValueAsString((Object)new JsonResponse(requestedUpdate, message));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String wasNotChangedMessage(RequestedUpdate requestedUpdate) {
        return String.format("State of '%s' was already '%s'", new Object[]{requestedUpdate.plugin().name(), requestedUpdate.newState()});
    }

    private static String wasChangedMessage(RequestedUpdate requestedUpdate) {
        return String.format("State of '%s' changed to '%s'", new Object[]{requestedUpdate.plugin().name(), requestedUpdate.newState()});
    }

    private static Matcher urlMatcher(HttpRequest request) {
        Matcher matcher = URL_PATTERN.matcher(request.path());
        if (!matcher.matches()) {
            throw new BadPluginToggleRequestException("Invalid URL");
        }
        return matcher;
    }

    private static Eventual<PluginEnabledState> requestedNewState(HttpRequest request) {
        return Eventual.of((Object)((Object)PluginEnabledState.fromBoolean(PluginToggleHandler.parseToBoolean(request.bodyAs(StandardCharsets.UTF_8)))));
    }

    private static HttpResponse responseWith(HttpResponseStatus status, String message) {
        return HttpResponse.response((HttpResponseStatus)status).body(message + "\n", StandardCharsets.UTF_8).addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.PLAIN_TEXT_UTF_8.toString()).disableCaching().build();
    }

    private static Eventual<HttpResponse> handleErrors(Throwable e, HttpInterceptor.Context context) {
        if (e instanceof PluginNotFoundException) {
            return Eventual.of((Object)PluginToggleHandler.responseWith(HttpResponseStatus.NOT_FOUND, e.getMessage()));
        }
        if (e instanceof BadPluginToggleRequestException) {
            return Eventual.of((Object)PluginToggleHandler.responseWith(HttpResponseStatus.BAD_REQUEST, e.getMessage()));
        }
        LOGGER.error("Plugin toggle error", e);
        return Eventual.of((Object)PluginToggleHandler.responseWith(HttpResponseStatus.INTERNAL_SERVER_ERROR, ""));
    }

    private NamedPlugin plugin(HttpRequest request) {
        Matcher matcher = PluginToggleHandler.urlMatcher(request);
        String pluginName = matcher.group(1);
        return this.plugin(pluginName);
    }

    private static boolean parseToBoolean(String string) {
        switch (string.toLowerCase()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new BadPluginToggleRequestException("No such state: only 'true' and 'false' are valid.");
    }

    private NamedPlugin plugin(String pluginName) {
        return this.plugins.stream().filter(p -> p.name().equals(pluginName)).findFirst().orElseThrow(() -> new PluginNotFoundException("No such plugin: pluginName=" + pluginName));
    }

    private static class PluginNotFoundException
    extends RuntimeException {
        PluginNotFoundException(String message) {
            super(message);
        }
    }

    private static class BadPluginToggleRequestException
    extends RuntimeException {
        BadPluginToggleRequestException(String message) {
            super(message);
        }
    }

    private static class JsonResponse {
        private final RequestedUpdate requestedUpdate;
        private final String message;

        JsonResponse(RequestedUpdate requestedUpdate, String message) {
            this.requestedUpdate = requestedUpdate;
            this.message = message;
        }

        @JsonProperty(value="plugin")
        public RequestedUpdate plugin() {
            return this.requestedUpdate;
        }

        @JsonProperty(value="message")
        public String message() {
            return this.message;
        }
    }

    private static class RequestedUpdate {
        private final NamedPlugin plugin;
        private final PluginEnabledState newState;

        RequestedUpdate(NamedPlugin plugin, PluginEnabledState newState) {
            this.plugin = plugin;
            this.newState = newState;
        }

        NamedPlugin plugin() {
            return this.plugin;
        }

        PluginEnabledState newState() {
            return this.newState;
        }

        boolean isPluginAlreadyInDesiredState() {
            return this.newState.matches(this.plugin);
        }

        boolean apply() {
            if (this.isPluginAlreadyInDesiredState()) {
                return false;
            }
            this.plugin.setEnabled(this.newState.isEnabled());
            return true;
        }

        @JsonProperty(value="name")
        public String name() {
            return this.plugin.name();
        }

        @JsonProperty(value="state")
        public String state() {
            return this.newState.toString();
        }
    }

    private static enum PluginEnabledState {
        ENABLED,
        DISABLED;


        public String toString() {
            return this.name().toLowerCase();
        }

        public boolean isEnabled() {
            return this == ENABLED;
        }

        public boolean matches(NamedPlugin plugin) {
            return plugin.enabled() == this.isEnabled();
        }

        public static PluginEnabledState fromBoolean(boolean enabled) {
            return enabled ? ENABLED : DISABLED;
        }

        public static int maxContentBytes() {
            return Stream.of(PluginEnabledState.values()).map(PluginEnabledState::toString).map(String::getBytes).map(bytes -> ((byte[])bytes).length).max(Comparator.naturalOrder()).orElseThrow(IllegalStateException::new);
        }
    }
}

