/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.google.common.net.MediaType;
import com.hotels.styx.StyxObjectRecord;
import com.hotels.styx.admin.AdminServerBuilder;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.api.configuration.ObjectStore;
import com.hotels.styx.api.extension.service.spi.StyxService;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public class ProviderListHandler
implements WebServiceHandler {
    private static final String HTML_TEMPLATE = "<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"UTF-8\">\n<title>%s</title>\n</head>\n\n<body>\n%s\n</body>\n</html>";
    private static final String TITLE = "List of Providers";
    private final ObjectStore<? extends StyxObjectRecord<? extends StyxService>> providerDb;

    public ProviderListHandler(ObjectStore<? extends StyxObjectRecord<? extends StyxService>> providerDb) {
        this.providerDb = providerDb;
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        String providerList = this.providerDb.entrySet().stream().map(entry -> ProviderListHandler.htmlForProvider((String)entry.getKey(), (StyxObjectRecord)entry.getValue())).collect(Collectors.joining());
        String html = String.format(HTML_TEMPLATE, TITLE, ProviderListHandler.h2(TITLE) + providerList);
        return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).body(html, StandardCharsets.UTF_8).addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.HTML_UTF_8.toString()).build());
    }

    private static String htmlForProvider(String name, StyxObjectRecord<? extends StyxService> provider) {
        String endpointList = provider.getStyxService().adminInterfaceHandlers(AdminServerBuilder.adminPath("providers", name)).keySet().stream().map(relativePath -> AdminServerBuilder.adminEndpointPath("providers", name, relativePath)).map(absolutePath -> ProviderListHandler.li(ProviderListHandler.link(absolutePath, absolutePath))).collect(Collectors.joining());
        return ProviderListHandler.h3(name + " (" + provider.getType() + ")") + "<ul>\n" + endpointList + "</ul>\n";
    }

    private static String h2(String content) {
        return String.format("<h2>%s</h2>\n", content);
    }

    private static String h3(String content) {
        return String.format("<h3>%s</h3>\n", content);
    }

    private static String link(String href, String text) {
        return String.format("<a href=\"%s\">%s</a>", href, text);
    }

    private static String li(String content) {
        return String.format("<li>%s</li>\n", content);
    }
}

