/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.hotels.styx.StyxObjectRecord;
import com.hotels.styx.admin.handlers.ProviderListHandler;
import com.hotels.styx.admin.handlers.UrlPatternRouter;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.api.configuration.ObjectStore;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.common.http.handler.HttpStreamer;
import com.hotels.styx.infrastructure.configuration.json.ObjectMappers;
import com.hotels.styx.routing.db.StyxObjectStore;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class ProviderRoutingHandler
implements WebServiceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderRoutingHandler.class);
    private static final int MEGABYTE = 0x100000;
    private static final ObjectMapper YAML_MAPPER = ObjectMappers.addStyxMixins(new ObjectMapper((JsonFactory)new YAMLFactory())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
    private final String pathPrefix;
    private volatile UrlPatternRouter router;

    public ProviderRoutingHandler(String pathPrefix, StyxObjectStore<? extends StyxObjectRecord<? extends StyxService>> providerDb) {
        this.pathPrefix = pathPrefix;
        Flux.from(providerDb.watch()).subscribe(this::refreshRoutes, error -> LOG.error("Error in providerDB subscription", error));
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        return this.router.handle(request, context);
    }

    private void refreshRoutes(ObjectStore<? extends StyxObjectRecord<? extends StyxService>> db) {
        LOG.info("Refreshing provider admin endpoint routes");
        this.router = this.buildRouter(db);
    }

    private UrlPatternRouter buildRouter(ObjectStore<? extends StyxObjectRecord<? extends StyxService>> db) {
        UrlPatternRouter.Builder routeBuilder = new UrlPatternRouter.Builder(this.pathPrefix).get("", new ProviderListHandler(db)).get("objects", (request, context) -> this.handleRequestForAllObjects(db)).get("objects/:objectName", (request, context) -> {
            String name = UrlPatternRouter.placeholders(context).get("objectName");
            return this.handleRequestForOneObject(db, name);
        });
        db.entrySet().forEach(entry -> {
            String providerName = (String)entry.getKey();
            ((StyxService)((StyxObjectRecord)entry.getValue()).getStyxService()).adminInterfaceHandlers(this.pathPrefix + "/" + providerName).forEach((relPath, handler) -> routeBuilder.get(providerName + "/" + relPath, (WebServiceHandler)new HttpStreamer(0x100000, handler)));
        });
        return routeBuilder.build();
    }

    private Eventual<HttpResponse> handleRequestForAllObjects(ObjectStore<? extends StyxObjectRecord<? extends StyxService>> db) {
        Map<String, StyxObjectRecord> objects = db.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String output = ProviderRoutingHandler.serialise(objects);
        return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).body(output, StandardCharsets.UTF_8).build());
    }

    private Eventual<HttpResponse> handleRequestForOneObject(ObjectStore<? extends StyxObjectRecord<? extends StyxService>> db, String name) {
        try {
            String object = db.get(name).map(ProviderRoutingHandler::serialise).orElseThrow(() -> new ResourceNotFoundException());
            return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).body(object, StandardCharsets.UTF_8).build());
        }
        catch (ResourceNotFoundException e) {
            return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.NOT_FOUND).build());
        }
    }

    private static String serialise(Object object) {
        JsonNode json = YAML_MAPPER.addMixIn(StyxObjectRecord.class, ProviderObjectDefMixin.class).valueToTree(object);
        try {
            return YAML_MAPPER.writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static abstract class ProviderObjectDefMixin {
        private ProviderObjectDefMixin() {
        }

        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="tags")
        public abstract List<String> tags();

        @JsonProperty(value="config")
        public abstract JsonNode config();

        @JsonIgnore
        public abstract Object getStyxService();
    }

    private static class ResourceNotFoundException
    extends RuntimeException {
        private ResourceNotFoundException() {
        }
    }
}

