/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.hotels.styx.admin.handlers.UrlPatternRouter;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.infrastructure.configuration.json.ObjectMappers;
import com.hotels.styx.routing.RoutingMetadataDecorator;
import com.hotels.styx.routing.RoutingObjectRecord;
import com.hotels.styx.routing.config.Builtins;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import com.hotels.styx.routing.db.StyxObjectStore;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RoutingObjectHandler
implements WebServiceHandler {
    private static final ObjectMapper YAML_MAPPER = ObjectMappers.addStyxMixins(new ObjectMapper((JsonFactory)new YAMLFactory())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
    private final UrlPatternRouter urlRouter = new UrlPatternRouter.Builder().get("/admin/routing/objects", (request, context) -> {
        Map<String, RoutingObjectRecord> objects = routeDatabase.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String output = RoutingObjectHandler.serialise(objects);
        return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).body(output, StandardCharsets.UTF_8).build());
    }).get("/admin/routing/objects/:objectName", (request, context) -> {
        String name = UrlPatternRouter.placeholders(context).get("objectName");
        try {
            String object = routeDatabase.get(name).map(RoutingObjectHandler::serialise).orElseThrow(() -> new ResourceNotFoundException());
            return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).body(object, StandardCharsets.UTF_8).build());
        }
        catch (ResourceNotFoundException e) {
            return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.NOT_FOUND).build());
        }
    }).put("/admin/routing/objects/:objectName", (request, context) -> {
        String body = request.bodyAs(StandardCharsets.UTF_8);
        String name = UrlPatternRouter.placeholders(context).get("objectName");
        try {
            StyxObjectDefinition payload = (StyxObjectDefinition)YAML_MAPPER.readValue(body, StyxObjectDefinition.class);
            RoutingMetadataDecorator decorator = new RoutingMetadataDecorator(Builtins.build((List<String>)ImmutableList.of((Object)name), routingObjectFactoryContext, payload));
            routeDatabase.insert(name, new RoutingObjectRecord(payload.type(), (Set<String>)ImmutableSet.copyOf(payload.tags()), payload.config(), decorator)).ifPresent(previous -> previous.getRoutingObject().stop());
            return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.CREATED).build());
        }
        catch (IOException | RuntimeException cause) {
            return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST).body(cause.toString(), StandardCharsets.UTF_8).build());
        }
    }).delete("/admin/routing/objects/:objectName", (request, context) -> {
        String name = UrlPatternRouter.placeholders(context).get("objectName");
        return routeDatabase.remove(name).map(previous -> previous.getRoutingObject().stop()).map(previous -> Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).build())).orElse(Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.NOT_FOUND).build()));
    }).build();

    public RoutingObjectHandler(StyxObjectStore<RoutingObjectRecord> routeDatabase, RoutingObjectFactory.Context routingObjectFactoryContext) {
    }

    private static String serialise(Object object) {
        JsonNode json = YAML_MAPPER.addMixIn(RoutingObjectRecord.class, RoutingObjectDefMixin.class).valueToTree(object);
        try {
            return YAML_MAPPER.writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        return this.urlRouter.handle(request, context);
    }

    private static abstract class RoutingObjectDefMixin {
        private RoutingObjectDefMixin() {
        }

        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="tags")
        public abstract List<String> tags();

        @JsonProperty(value="config")
        public abstract JsonNode config();

        @JsonIgnore
        public abstract Object getRoutingObject();
    }

    private static class ResourceNotFoundException
    extends RuntimeException {
        private ResourceNotFoundException() {
        }
    }
}

