/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.StyxObjectRecord;
import com.hotels.styx.admin.handlers.UrlPatternRouter;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.infrastructure.configuration.json.ObjectMappers;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import com.hotels.styx.routing.db.StyxObjectStore;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProviderHandler
implements WebServiceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceProviderHandler.class);
    private static final ObjectMapper YAML_MAPPER = ObjectMappers.addStyxMixins(new ObjectMapper((JsonFactory)new YAMLFactory())).addMixIn(StyxObjectDefinition.class, ServiceProviderDefMixin.class).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
    private final UrlPatternRouter urlRouter = new UrlPatternRouter.Builder().get("/admin/service/providers", (request, context) -> {
        try {
            String output = providerDatabase.entrySet().stream().map(entry -> ServiceProviderHandler.serialise((String)entry.getKey(), (StyxObjectRecord)entry.getValue())).collect(Collectors.joining("\n"));
            HttpResponse response = output.length() > 0 ? HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).body(output, StandardCharsets.UTF_8).build() : HttpResponse.response((HttpResponseStatus)HttpResponseStatus.NO_CONTENT).build();
            return Eventual.of((Object)response);
        }
        catch (RuntimeException cause) {
            LOGGER.error("Unable to construct response for list of service providers", (Throwable)cause);
            return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST).body(cause.toString(), StandardCharsets.UTF_8).build());
        }
    }).get("/admin/service/provider/:providerName", (request, context) -> {
        String name = UrlPatternRouter.placeholders(context).get("providerName");
        try {
            Optional<String> object = providerDatabase.get(name).map(record -> ServiceProviderHandler.serialise(name, record));
            HttpResponse response = object.isPresent() ? HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).body(object.get(), StandardCharsets.UTF_8).build() : HttpResponse.response((HttpResponseStatus)HttpResponseStatus.NOT_FOUND).build();
            return Eventual.of((Object)response);
        }
        catch (RuntimeException cause) {
            LOGGER.error("Unable to construct response for service provider [" + name + "]", (Throwable)cause);
            return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST).body(cause.toString(), StandardCharsets.UTF_8).build());
        }
    }).build();

    public ServiceProviderHandler(StyxObjectStore<StyxObjectRecord<StyxService>> providerDatabase) {
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        return this.urlRouter.handle(request, context);
    }

    public static ObjectMapper yamlMapper() {
        return YAML_MAPPER.copy();
    }

    private static String serialise(String name, StyxObjectRecord<StyxService> record) {
        ImmutableList tags = ImmutableList.copyOf(record.getTags());
        StyxObjectDefinition objectDef = new StyxObjectDefinition(name, record.getType(), (List<String>)tags, record.getConfig());
        JsonNode node = YAML_MAPPER.valueToTree((Object)objectDef);
        ((ObjectNode)node).set("config", record.getConfig());
        try {
            return YAML_MAPPER.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static abstract class ServiceProviderDefMixin {
        private ServiceProviderDefMixin() {
        }

        @JsonProperty(value="name")
        public abstract String name();

        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="tags")
        public abstract List<String> tags();
    }
}

