/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import com.hotels.styx.admin.support.Json;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.common.http.handler.StaticBodyHttpHandler;
import java.util.Map;

public class StyxConfigurationHandler
implements WebServiceHandler {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final StaticBodyHttpHandler styxConfigHandler;
    private final StaticBodyHttpHandler prettyStyxConfigHandler;

    public StyxConfigurationHandler(Configuration configuration) {
        this.styxConfigHandler = new StaticBodyHttpHandler(MediaType.PLAIN_TEXT_UTF_8, StyxConfigurationHandler.body(configuration));
        this.prettyStyxConfigHandler = new StaticBodyHttpHandler(MediaType.PLAIN_TEXT_UTF_8, this.prettify(configuration));
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        return this.configHandler(request.queryParam("pretty").isPresent()).handle(request, context).map(StyxConfigurationHandler::disableCaching);
    }

    private StaticBodyHttpHandler configHandler(boolean pretty) {
        return pretty ? this.prettyStyxConfigHandler : this.styxConfigHandler;
    }

    private static HttpResponse disableCaching(HttpResponse response) {
        return response.newBuilder().disableCaching().build();
    }

    private static String body(Configuration styxConfig) {
        return styxConfig + "\n";
    }

    private String prettify(Configuration configuration) {
        try {
            return this.objectMapper.writer(Json.PRETTY_PRINTER).writeValueAsString(this.objectMapper.readValue(StyxConfigurationHandler.body(configuration), Map.class));
        }
        catch (Error | RuntimeException cause) {
            throw cause;
        }
        catch (Exception cause) {
            throw new RuntimeException(cause);
        }
    }
}

