/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpMethod;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.WebServiceHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlPatternRouter
implements WebServiceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlPatternRouter.class);
    private static final String PLACEHOLDERS_KEY = "UrlRouter.placeholders";
    private final List<RouteDescriptor> alternatives;

    private UrlPatternRouter(List<RouteDescriptor> alternatives) {
        this.alternatives = ImmutableList.copyOf(alternatives);
    }

    public static Map<String, String> placeholders(HttpInterceptor.Context context) {
        return (Map)context.getIfAvailable(PLACEHOLDERS_KEY, Map.class).get();
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        for (RouteDescriptor route : this.alternatives) {
            if (!request.method().equals(route.method())) continue;
            Matcher match = route.uriPattern().matcher(request.path());
            LOGGER.debug("Request path '{}' matching against route pattern '{}' matches: {}", new Object[]{request.path(), route.uriPattern(), match.matches()});
            if (!match.matches()) continue;
            Map<String, String> placeholders = route.placeholderNames().stream().collect(Collectors.toMap(name -> name, match::group));
            context.add(PLACEHOLDERS_KEY, placeholders);
            try {
                return route.handler().handle(request, context);
            }
            catch (Exception cause) {
                LOGGER.error("ERROR: {} {}", new Object[]{request.method(), request.path(), cause});
                return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR).build());
            }
        }
        return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.NOT_FOUND).build());
    }

    private static class RouteDescriptor {
        private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(":([a-zA-Z0-9-_]+)");
        private final HttpMethod method;
        private final Pattern uriPattern;
        private final WebServiceHandler handler;
        private final List<String> placeholderNames;

        public RouteDescriptor(HttpMethod method, String uriPattern, WebServiceHandler handler) {
            this.method = method;
            this.handler = handler;
            this.placeholderNames = RouteDescriptor.placeholders(uriPattern);
            this.uriPattern = RouteDescriptor.compilePattern(uriPattern);
        }

        public HttpMethod method() {
            return this.method;
        }

        public Pattern uriPattern() {
            return this.uriPattern;
        }

        public WebServiceHandler handler() {
            return this.handler;
        }

        public List<String> placeholderNames() {
            return this.placeholderNames;
        }

        private static Pattern compilePattern(String pattern) {
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(pattern);
            return Pattern.compile(matcher.replaceAll("(?<$1>[a-zA-Z0-9-_.]+)"));
        }

        private static List<String> placeholders(String pattern) {
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(pattern);
            ArrayList<String> outcome = new ArrayList<String>();
            while (matcher.find()) {
                outcome.add(matcher.group(1));
            }
            return outcome;
        }
    }

    public static class Builder {
        private final List<RouteDescriptor> alternatives = new LinkedList<RouteDescriptor>();
        private final String pathPrefix;

        public Builder() {
            this("");
        }

        public Builder(String pathPrefix) {
            this.pathPrefix = pathPrefix.endsWith("/") ? pathPrefix.substring(pathPrefix.length() - 1) : pathPrefix;
        }

        public Builder get(String uriPattern, WebServiceHandler handler) {
            this.alternatives.add(new RouteDescriptor(HttpMethod.GET, this.addPrefix(uriPattern), handler));
            return this;
        }

        public Builder post(String uriPattern, WebServiceHandler handler) {
            this.alternatives.add(new RouteDescriptor(HttpMethod.POST, this.addPrefix(uriPattern), handler));
            return this;
        }

        public Builder put(String uriPattern, WebServiceHandler handler) {
            this.alternatives.add(new RouteDescriptor(HttpMethod.PUT, this.addPrefix(uriPattern), handler));
            return this;
        }

        public Builder delete(String uriPattern, WebServiceHandler handler) {
            this.alternatives.add(new RouteDescriptor(HttpMethod.DELETE, this.addPrefix(uriPattern), handler));
            return this;
        }

        private String addPrefix(String uriPattern) {
            StringBuilder path = new StringBuilder(this.pathPrefix);
            if (uriPattern.length() > 0 && !uriPattern.startsWith("/")) {
                path.append("/");
            }
            path.append(uriPattern);
            return path.toString();
        }

        public UrlPatternRouter build() {
            return new UrlPatternRouter(this.alternatives);
        }
    }
}

