/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers;

import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import com.hotels.styx.api.Resource;
import com.hotels.styx.common.Preconditions;
import com.hotels.styx.common.http.handler.StaticBodyHttpHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionTextHandler
extends StaticBodyHttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(VersionTextHandler.class);

    public VersionTextHandler(Iterable<Resource> files) {
        super(MediaType.PLAIN_TEXT_UTF_8, VersionTextHandler.body(files));
    }

    private static String body(Iterable<Resource> files) {
        Preconditions.checkArgument((!Iterables.isEmpty(files) ? 1 : 0) != 0);
        return VersionTextHandler.versionFileContent(files).orElse("Unknown version\n");
    }

    private static Optional<String> versionFileContent(Iterable<Resource> files) {
        StringBuilder builder = new StringBuilder();
        files.forEach(versionFile -> VersionTextHandler.readString(versionFile).ifPresent(content -> builder.append((String)content).append('\n')));
        return builder.length() > 0 ? Optional.of(builder.toString()) : Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> readString(Resource resource) {
        try (BufferedReader reader = VersionTextHandler.bufferedReader(resource);){
            Optional<String> optional = Optional.of(CharStreams.toString((Readable)reader));
            return optional;
        }
        catch (IOException e) {
            LOG.warn("Could not load file={}", (Object)resource.path());
            return Optional.empty();
        }
    }

    private static BufferedReader bufferedReader(Resource resource) throws IOException {
        return new BufferedReader(new InputStreamReader(resource.inputStream()));
    }
}

