/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.handlers.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class JsonReformatter {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String LINE_SEPARATOR = "\n";

    private JsonReformatter() {
    }

    public static String reformat(String json) {
        try {
            return JsonReformatter.reformat0(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String reformat0(String json) throws IOException {
        Tree tree = new Tree();
        ((Map)MAPPER.readValue(json, Map.class)).forEach((key, value) -> tree.add(String.valueOf(key), value));
        return tree.pretty();
    }

    private static class Tree {
        private static final Pattern IS_NUMBER = Pattern.compile("-?([0-9]+.)?[0-9]+");
        private final Map<String, Tree> children = new TreeMap<String, Tree>();
        private final Object value;

        Tree() {
            this(null);
        }

        Tree(Object value) {
            this.value = value;
        }

        public void add(String name, Object value) {
            int firstDot = name.indexOf(46);
            if (firstDot == -1) {
                Tree tree;
                if (value instanceof Map) {
                    tree = new Tree();
                    ((Map)value).forEach((k, v) -> tree.add(String.valueOf(k), v));
                } else {
                    tree = new Tree(value);
                }
                this.children.put(name, tree);
            } else {
                String prefix = name.substring(0, firstDot);
                String suffix = name.substring(firstDot + 1, name.length());
                Tree tree = this.children.computeIfAbsent(prefix, k -> new Tree());
                tree.add(suffix, value);
            }
        }

        public String pretty() {
            return this.pretty(0);
        }

        private String pretty(int indentation) {
            String indent = Tree.indent(indentation);
            String indent1 = Tree.indent(indentation + 1);
            StringBuilder json = new StringBuilder();
            if (this.value != null) {
                if (indentation > 0) {
                    json.append("\":");
                }
                if (!Tree.isNumber(String.valueOf(this.value))) {
                    json.append('\"').append(this.value).append('\"');
                } else {
                    json.append(this.value);
                }
            } else if (this.children.size() == 1) {
                Map.Entry entry2 = (Map.Entry)this.children.entrySet().stream().findFirst().orElseThrow(IllegalStateException::new);
                if (indentation == 0) {
                    json.append("{\"");
                } else {
                    json.append(".");
                }
                json.append((String)entry2.getKey()).append(((Tree)entry2.getValue()).pretty(indentation + 1));
                if (indentation == 0) {
                    json.append("}");
                }
            } else {
                if (indentation > 0) {
                    json.append("\":");
                }
                json.append("{").append(JsonReformatter.LINE_SEPARATOR).append(this.children.entrySet().stream().map(entry -> indent1 + '\"' + (String)entry.getKey() + ((Tree)entry.getValue()).pretty(indentation + 1)).collect(Collectors.joining(",\n"))).append(JsonReformatter.LINE_SEPARATOR);
                if (indentation > 0) {
                    json.append(indent);
                }
                json.append("}");
            }
            return json.toString();
        }

        private static boolean isNumber(String s) {
            return IS_NUMBER.matcher(s).matches();
        }

        private static String indent(int indentation) {
            char[] spaces = new char[indentation * 2];
            Arrays.fill(spaces, ' ');
            return String.valueOf(spaces);
        }
    }
}

