/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.tasks;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.extension.OriginsChangeListener;
import com.hotels.styx.api.extension.OriginsSnapshot;
import com.hotels.styx.client.origincommands.DisableOrigin;
import com.hotels.styx.client.origincommands.EnableOrigin;
import com.hotels.styx.client.origincommands.GetOriginsInventorySnapshot;
import com.hotels.styx.common.Strings;
import com.hotels.styx.common.http.handler.BaseHttpHandler;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OriginsCommandHandler
extends BaseHttpHandler
implements OriginsChangeListener {
    private static final String INVALID_APP_ID_FORMAT = "application with id=%s is not found";
    private static final String INVALID_ORIGIN_ID_FORMAT = "origin with id=%s is not found for application=%s";
    private static final List<String> VALID_COMMANDS = ImmutableList.of((Object)"enable_origin", (Object)"disable_origin");
    private static final String MISSING_ERROR_MESSAGE = String.format("cmd, appId and originId are all required parameters. cmd can be %s", String.join((CharSequence)"|", VALID_COMMANDS));
    private final EventBus eventBus;
    private final Map<Id, OriginsSnapshot> originsInventorySnapshotMap = new ConcurrentHashMap<Id, OriginsSnapshot>();

    public OriginsCommandHandler(EventBus eventBus) {
        this.eventBus = eventBus;
        this.eventBus.register((Object)this);
        this.eventBus.post((Object)new GetOriginsInventorySnapshot());
    }

    public HttpResponse doHandle(HttpRequest request, HttpInterceptor.Context context) {
        String cmd = request.queryParam("cmd").orElse("");
        String appId = request.queryParam("appId").orElse("");
        String originId = request.queryParam("originId").orElse("");
        if (!OriginsCommandHandler.isValidCommand(cmd) || Strings.isNullOrEmpty((String)appId) || Strings.isNullOrEmpty((String)originId)) {
            return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST).body(MISSING_ERROR_MESSAGE, StandardCharsets.UTF_8).build();
        }
        if (!this.originsInventorySnapshotMap.containsKey(Id.id((String)appId))) {
            return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST).body(String.format(INVALID_APP_ID_FORMAT, appId), StandardCharsets.UTF_8).build();
        }
        if (!this.validOriginId(Id.id((String)appId), Id.id((String)originId))) {
            return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST).body(String.format(INVALID_ORIGIN_ID_FORMAT, originId, appId), StandardCharsets.UTF_8).build();
        }
        Object originCommand = OriginsCommandHandler.newOriginCommand(cmd, Id.id((String)appId), Id.id((String)originId));
        this.eventBus.post(originCommand);
        return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.TEMPORARY_REDIRECT).header(HttpHeaderNames.LOCATION, (Object)"/admin/origins/status").header(HttpHeaderNames.CONTENT_LENGTH, (Object)0).build();
    }

    private boolean validOriginId(Id appId, Id originId) {
        OriginsSnapshot inventorySnapshot = this.originsInventorySnapshotMap.get(appId);
        return inventorySnapshot.containsOrigin(originId);
    }

    private static Object newOriginCommand(String cmd, Id appId, Id originId) {
        switch (cmd) {
            case "enable_origin": {
                return new EnableOrigin(appId, originId);
            }
            case "disable_origin": {
                return new DisableOrigin(appId, originId);
            }
        }
        throw new IllegalArgumentException(cmd);
    }

    private static boolean isValidCommand(String cmd) {
        return VALID_COMMANDS.contains(cmd);
    }

    @Subscribe
    public void originsChanged(OriginsSnapshot snapshot) {
        this.originsInventorySnapshotMap.put(snapshot.appId(), snapshot);
    }
}

