/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.admin.tasks;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.net.MediaType;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.WebServiceHandler;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.spi.Registry;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Schedulers;

public class OriginsReloadCommandHandler
implements WebServiceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OriginsReloadCommandHandler.class);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Registry<BackendService> backendServicesRegistry;

    public OriginsReloadCommandHandler(Registry<BackendService> backendServicesRegistry) {
        this.backendServicesRegistry = Objects.requireNonNull(backendServicesRegistry);
    }

    public Eventual<HttpResponse> handle(HttpRequest request, HttpInterceptor.Context context) {
        return new Eventual((Publisher)Flux.create(this::reload).subscribeOn(Schedulers.fromExecutor((Executor)this.executor)));
    }

    private void reload(FluxSink<? super HttpResponse> subscriber) {
        this.backendServicesRegistry.reload().handle((result2, exception) -> {
            if (exception == null) {
                if (result2.outcome() == Registry.Outcome.RELOADED) {
                    subscriber.next((Object)this.okResponse("Origins reloaded successfully.\n"));
                    subscriber.complete();
                } else if (result2.outcome() == Registry.Outcome.UNCHANGED) {
                    subscriber.next((Object)this.okResponse(String.format("Origins were not reloaded because %s.\n", result2.message())));
                    subscriber.complete();
                } else {
                    subscriber.error(this.mapError((Registry.ReloadResult)result2));
                }
            } else {
                subscriber.next((Object)this.errorResponse((Throwable)exception));
                subscriber.complete();
            }
            return null;
        });
    }

    private Throwable mapError(Registry.ReloadResult result2) {
        if (result2.cause().isPresent()) {
            return new RuntimeException((Throwable)result2.cause().get());
        }
        return new RuntimeException("Reload failure");
    }

    private HttpResponse okResponse(String content) {
        return HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).header(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.PLAIN_TEXT_UTF_8).body(content, StandardCharsets.UTF_8).build();
    }

    private HttpResponse errorResponse(Throwable cause) {
        String errorId = UUID.randomUUID().toString();
        LOG.error("id={}", (Object)errorId, (Object)cause);
        if (this.deSerialisationError(cause)) {
            return this.errorResponse(HttpResponseStatus.BAD_REQUEST, String.format("There was an error processing your request. It has been logged (ID %s).\n", errorId));
        }
        return this.errorResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("There was an error processing your request. It has been logged (ID %s).\n", errorId));
    }

    private boolean deSerialisationError(Throwable cause) {
        Throwable subCause = cause.getCause();
        if (subCause instanceof JsonMappingException) {
            return true;
        }
        Throwable throwable = subCause = subCause != null ? subCause.getCause() : null;
        return subCause instanceof JsonMappingException;
    }

    private HttpResponse errorResponse(HttpResponseStatus code, String content) {
        return HttpResponse.response((HttpResponseStatus)code).header(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.PLAIN_TEXT_UTF_8).body(content, StandardCharsets.UTF_8).build();
    }
}

