/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.applications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.hotels.styx.api.extension.Origin;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.common.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class BackendServices
implements Iterable<BackendService> {
    private final Collection<BackendService> backendServices;

    @JsonCreator
    BackendServices(@JsonProperty(value="applications") Collection<BackendService> backendServices) {
        this(backendServices, true);
    }

    private BackendServices(Collection<BackendService> backendServices, boolean setDerivedAttributes) {
        Preconditions.checkArgument((boolean)BackendServices.noDuplicateIds(backendServices), (Object)("Duplicate ids in " + backendServices));
        this.backendServices = setDerivedAttributes ? ImmutableSet.copyOf((Collection)backendServices.stream().map(BackendServices::setDerivedAttributes).collect(Collectors.toList())) : backendServices;
    }

    private static boolean noDuplicateIds(Collection<BackendService> backendServices) {
        Set ids = backendServices.stream().map(BackendService::id).collect(Collectors.toSet());
        return ids.size() == backendServices.size();
    }

    public static BackendServices newBackendServices(Iterable<BackendService> applications) {
        return new BackendServices((Collection<BackendService>)ImmutableSet.copyOf(applications), true);
    }

    public static BackendServices newBackendServices(BackendService ... backendServices) {
        return new BackendServices((Collection<BackendService>)ImmutableSet.copyOf((Object[])backendServices), true);
    }

    private static BackendService setDerivedAttributes(BackendService application) {
        return BackendService.newBackendServiceBuilder((BackendService)application).origins(BackendServices.originsWithDerivedApplicationIds(application)).build();
    }

    private static Set<Origin> originsWithDerivedApplicationIds(BackendService backendService) {
        return ImmutableSet.copyOf(BackendServices.originsWithApplicationId(backendService));
    }

    private static Iterable<Origin> originsWithApplicationId(BackendService backendService) {
        return backendService.origins().stream().map(origin -> Origin.newOriginBuilder((Origin)origin).applicationId(backendService.id()).build()).collect(Collectors.toList());
    }

    @JsonProperty(value="applications")
    Collection<BackendService> applications() {
        return this.backendServices;
    }

    public Iterable<Origin> origins() {
        return this.backendServices.stream().map(BackendService::origins).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Iterator<BackendService> iterator() {
        return this.backendServices.iterator();
    }

    public BackendService first() {
        BackendService first = (BackendService)Iterables.getFirst((Iterable)this, null);
        if (first == null) {
            throw new NoSuchElementException();
        }
        return first;
    }

    public String toString() {
        return new StringBuilder(32).append(this.getClass().getSimpleName()).append("{backendServices=").append(this.backendServices).append('}').toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.backendServices);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BackendServices other = (BackendServices)obj;
        return Objects.equals(this.backendServices, other.backendServices);
    }
}

