/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.applications.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.hotels.styx.api.Resource;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.applications.BackendServices;
import com.hotels.styx.common.io.ResourceFactory;
import com.hotels.styx.infrastructure.configuration.json.ObjectMappers;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class YamlApplicationsProvider {
    private static final ObjectMapper MAPPER = ObjectMappers.addStyxMixins(new ObjectMapper((JsonFactory)new YAMLFactory()));
    private static final CollectionType TYPE = MAPPER.getTypeFactory().constructCollectionType(List.class, BackendService.class);
    private final BackendServices backendServices;

    private YamlApplicationsProvider(String yamlText) {
        this.backendServices = BackendServices.newBackendServices(YamlApplicationsProvider.readApplicationsFromText(yamlText));
    }

    public YamlApplicationsProvider(Resource resource) {
        this.backendServices = BackendServices.newBackendServices(YamlApplicationsProvider.readApplicationsFromResource(resource));
    }

    private static Iterable<BackendService> readApplicationsFromText(String yamlText) {
        try {
            return (Iterable)MAPPER.readValue(yamlText, (JavaType)TYPE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Iterable<BackendService> readApplicationsFromResource(Resource resource) {
        try (InputStream stream = resource.inputStream();){
            Iterable iterable = (Iterable)MAPPER.readValue(stream, (JavaType)TYPE);
            return iterable;
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(String.format("Invalid YAML from %s: %s", resource, e.getLocalizedMessage()), e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to load YAML from %s: %s", resource, e.getLocalizedMessage()), e);
        }
    }

    public static YamlApplicationsProvider loadFromPath(String path) {
        return new YamlApplicationsProvider(ResourceFactory.newResource((String)path));
    }

    public static YamlApplicationsProvider loadFromText(String yamlText) {
        return new YamlApplicationsProvider(yamlText);
    }

    public static BackendServices loadApplicationsFrom(String path) {
        return YamlApplicationsProvider.loadFromPath(path).get();
    }

    public BackendServices get() {
        return this.backendServices;
    }
}

