/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.hotels.styx.api.Identifiable;
import com.hotels.styx.api.Resource;
import com.hotels.styx.api.extension.service.spi.AbstractRegistry;
import com.hotels.styx.api.extension.service.spi.Registry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBackedRegistry<T extends Identifiable>
extends AbstractRegistry<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FileBackedRegistry.class);
    private final Resource configurationFile;
    private final Reader<T> reader;
    private final Supplier<FileTime> modifyTimeSupplier;
    private HashCode fileHash = HashCode.fromLong((long)0L);

    private FileBackedRegistry(Resource configurationFile, Reader<T> reader, Supplier<FileTime> modifyTimeSupplier, Predicate<Collection<T>> resourceConstraint) {
        super(resourceConstraint);
        this.configurationFile = Objects.requireNonNull(configurationFile);
        this.reader = Objects.requireNonNull(reader);
        this.modifyTimeSupplier = modifyTimeSupplier;
    }

    @VisibleForTesting
    FileBackedRegistry(Resource configurationFile, Reader<T> reader, Supplier<FileTime> modifyTimeSupplier) {
        this(configurationFile, reader, modifyTimeSupplier, any -> true);
    }

    public FileBackedRegistry(Resource configurationFile, Reader<T> reader, Predicate<Collection<T>> resourceConstraint) {
        this(configurationFile, reader, FileBackedRegistry.fileModificationTimeProvider(configurationFile), resourceConstraint);
    }

    public String fileName() {
        return this.configurationFile.absolutePath();
    }

    public CompletableFuture<Registry.ReloadResult> reload() {
        return CompletableFuture.supplyAsync(() -> {
            byte[] content = this.readFile();
            HashCode hashCode = Hashing.md5().hashBytes(content);
            String modifyTime = this.fileModificationTime().map(FileTime::toString).orElse("NA");
            String logPrefix = String.format("timestamp=%s, md5-hash=%s", modifyTime, hashCode);
            if (hashCode.equals((Object)this.fileHash)) {
                LOG.info("Not reloading {} as content did not change", (Object)this.configurationFile.absolutePath());
                return Registry.ReloadResult.unchanged((String)String.format("%s, Identical file content.", logPrefix));
            }
            try {
                boolean changesPerformed = this.updateResources(content, hashCode);
                if (!changesPerformed) {
                    LOG.info("Not firing change event for {} as content was not semantically different", (Object)this.configurationFile.absolutePath());
                    return Registry.ReloadResult.unchanged((String)String.format("%s, No semantic changes.", logPrefix));
                }
                LOG.debug("Changes applied!");
                return Registry.ReloadResult.reloaded((String)String.format("%s, File reloaded.", logPrefix));
            }
            catch (Exception e) {
                if (!"Resource constraint failure".equals(e.getMessage())) {
                    LOG.error("Not reloading {} as there was an error reading content", (Object)this.configurationFile.absolutePath(), (Object)e);
                }
                return Registry.ReloadResult.failed((String)String.format("%s, Reload failure.", logPrefix), (Throwable)e);
            }
        }, Executors.newSingleThreadExecutor());
    }

    private static Supplier<FileTime> fileModificationTimeProvider(Resource path) {
        return () -> {
            try {
                return Files.getLastModifiedTime(Paths.get(path.path(), new String[0]), new LinkOption[0]);
            }
            catch (Throwable cause) {
                throw new RuntimeException(cause);
            }
        };
    }

    private Optional<FileTime> fileModificationTime() {
        try {
            return Optional.of(this.modifyTimeSupplier.get());
        }
        catch (Throwable cause) {
            return Optional.empty();
        }
    }

    private boolean updateResources(byte[] content, HashCode hashCode) {
        Iterable<T> resources = this.reader.read(content);
        Registry.Changes changes = FileBackedRegistry.changes(resources, (Iterable)this.get());
        if (!changes.isEmpty()) {
            this.set(resources);
        }
        this.fileHash = hashCode;
        return !changes.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readFile() {
        try (InputStream configurationContent = this.configurationFile.inputStream();){
            byte[] byArray = ByteStreams.toByteArray((InputStream)configurationContent);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Reader<T> {
        public Iterable<T> read(byte[] var1);
    }
}

