/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure;

import com.google.common.collect.ImmutableSet;
import com.hotels.styx.api.Environment;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.Identifiable;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.extension.service.spi.AbstractRegistry;
import com.hotels.styx.api.extension.service.spi.Registry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class MemoryBackedRegistry<T extends Identifiable>
extends AbstractRegistry<T> {
    private final Map<Id, T> resources = new HashMap<Id, T>();
    private final boolean autoReload;

    public MemoryBackedRegistry() {
        this(true);
    }

    private MemoryBackedRegistry(boolean autoReload) {
        this.autoReload = autoReload;
    }

    public void add(T t) {
        this.resources.put(t.id(), t);
        if (this.autoReload) {
            this.reload();
        }
    }

    public void removeById(Id id) {
        this.resources.remove(id);
        if (this.autoReload) {
            this.reload();
        }
    }

    public void reset() {
        this.resources.clear();
        if (this.autoReload) {
            this.reload();
        }
    }

    public CompletableFuture<Registry.ReloadResult> reload() {
        this.set((Iterable)ImmutableSet.copyOf(this.resources.values()));
        return CompletableFuture.completedFuture(Registry.ReloadResult.reloaded((String)"changed"));
    }

    public static class Factory<T extends Identifiable>
    implements Registry.Factory<T> {
        public Registry<T> create(Environment environment, Configuration registryConfiguration) {
            return new MemoryBackedRegistry();
        }
    }
}

