/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.configuration;

import com.hotels.styx.common.Logging;
import com.hotels.styx.common.io.ResourceFactory;
import com.hotels.styx.infrastructure.configuration.ConfigurationFormat;
import com.hotels.styx.infrastructure.configuration.ConfigurationSource;
import com.hotels.styx.infrastructure.configuration.ExtensibleConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationParser<C extends ExtensibleConfiguration<C>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationParser.class);
    private final ConfigurationFormat<C> format;
    private final Map<String, String> overrides;

    private ConfigurationParser(Builder<C> builder) {
        this.format = Objects.requireNonNull(((Builder)builder).format);
        this.overrides = Objects.requireNonNull(((Builder)builder).overrides);
    }

    public C parse(ConfigurationSource provider) {
        LOGGER.debug("Parsing configuration in format={} from source={}", this.format, (Object)provider);
        Object configuration = this.doParse(provider).withOverrides(this.overrides);
        ExtensibleConfiguration.PlaceholderResolutionResult resolved = configuration.resolvePlaceholders(this.overrides);
        if (!resolved.unresolvedPlaceholders().isEmpty()) {
            throw new IllegalStateException(String.format("Unresolved placeholders: %s", resolved.unresolvedPlaceholders()));
        }
        return resolved.resolvedConfiguration();
    }

    private C doParse(ConfigurationSource provider) {
        C main = provider.deserialise(this.format);
        return (C)this.includedParentConfig(main).map(arg_0 -> main.withParent(arg_0)).orElse((ExtensibleConfiguration)main);
    }

    private Optional<C> includedParentConfig(C main) {
        return main.get("include").map(include -> this.format.resolvePlaceholdersInText((String)include, this.overrides)).map(ConfigurationParser::configurationSource).map(this::doParse);
    }

    private static ConfigurationSource configurationSource(String path) {
        LOGGER.info("Including config file: path={}", (Object)Logging.sanitise((String)path));
        return ConfigurationSource.configSource(ResourceFactory.newResource((String)path));
    }

    public static final class Builder<C extends ExtensibleConfiguration<C>> {
        private ConfigurationFormat<C> format;
        private Map<String, String> overrides = Collections.emptyMap();

        public Builder<C> format(ConfigurationFormat<C> format) {
            this.format = Objects.requireNonNull(format);
            return this;
        }

        public Builder<C> overrides(Map<String, String> overrides) {
            this.overrides = Objects.requireNonNull(overrides);
            return this;
        }

        public Builder<C> overrides(Properties properties) {
            return this.overrides((Map<String, String>)properties);
        }

        public ConfigurationParser<C> build() {
            return new ConfigurationParser(this);
        }
    }
}

