/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.configuration;

import com.hotels.styx.api.Resource;
import com.hotels.styx.infrastructure.configuration.ConfigurationFormat;
import com.hotels.styx.infrastructure.configuration.ExtensibleConfiguration;

public interface ConfigurationSource {
    public <C extends ExtensibleConfiguration<C>> C deserialise(ConfigurationFormat<C> var1);

    public static ConfigurationSource configSource(final String string) {
        return new ConfigurationSource(){

            @Override
            public <C extends ExtensibleConfiguration<C>> C deserialise(ConfigurationFormat<C> format) {
                return format.deserialise(string);
            }

            public String toString() {
                return "\"" + string + "\"";
            }
        };
    }

    public static ConfigurationSource configSource(final Resource resource) {
        return new ConfigurationSource(){

            @Override
            public <C extends ExtensibleConfiguration<C>> C deserialise(ConfigurationFormat<C> format) {
                return format.deserialise(resource);
            }

            public String toString() {
                return resource.toString();
            }
        };
    }
}

