/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.configuration;

import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.infrastructure.configuration.UnresolvedPlaceholder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public interface ExtensibleConfiguration<C extends ExtensibleConfiguration<C>>
extends Configuration {
    public C withParent(C var1);

    public C withOverrides(Map<String, String> var1);

    public PlaceholderResolutionResult<C> resolvePlaceholders(Map<String, String> var1);

    public static class PlaceholderResolutionResult<C extends ExtensibleConfiguration<C>> {
        private final C resolvedConfiguration;
        private final Collection<UnresolvedPlaceholder> unresolvedPlaceholders;

        public PlaceholderResolutionResult(C resolvedConfiguration, Collection<UnresolvedPlaceholder> unresolvedPlaceholders) {
            this.resolvedConfiguration = (ExtensibleConfiguration)Objects.requireNonNull(resolvedConfiguration);
            this.unresolvedPlaceholders = ImmutableList.copyOf(unresolvedPlaceholders);
        }

        public C resolvedConfiguration() {
            return this.resolvedConfiguration;
        }

        public Collection<UnresolvedPlaceholder> unresolvedPlaceholders() {
            return this.unresolvedPlaceholders;
        }
    }
}

