/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.configuration.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.configuration.ConversionException;
import com.hotels.styx.infrastructure.configuration.json.ObjectMappers;
import com.hotels.styx.infrastructure.configuration.yaml.NodePath;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;

public class JsonNodeConfig
implements Configuration {
    static final ObjectMapper YAML_MAPPER = ObjectMappers.addStyxMixins(new ObjectMapper((JsonFactory)new YAMLFactory()).registerModule((Module)new KotlinModule())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
    private final ObjectMapper mapper;
    private final JsonNode rootNode;

    public JsonNodeConfig(JsonNode rootNode) {
        this(rootNode, YAML_MAPPER);
    }

    protected JsonNodeConfig(JsonNode rootNode, ObjectMapper mapper) {
        this.rootNode = Objects.requireNonNull(rootNode);
        this.mapper = ObjectMappers.addStyxMixins(Objects.requireNonNull(mapper));
    }

    public Optional<String> get(String key) {
        return this.get(key, String.class);
    }

    public <T> Optional<T> get(String property, Class<T> tClass) {
        return this.nodeAt(property).map(node -> {
            if (tClass == Path.class) {
                return Paths.get(node.textValue(), new String[0]);
            }
            return this.parseNodeToClass((JsonNode)node, tClass);
        });
    }

    private Optional<JsonNode> nodeAt(String property) {
        NodePath nodePath = new NodePath(property);
        return nodePath.findMatchingDescendant(this.rootNode);
    }

    private <T> T parseNodeToClass(JsonNode node, Class<T> tClass) {
        JsonParser parser = node.traverse();
        try {
            return (T)this.mapper.readValue(parser, tClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <X> X as(Class<X> type) throws ConversionException {
        return this.parseNodeToClass(this.rootNode, type);
    }

    public String toString() {
        return this.rootNode.toString();
    }
}

