/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.configuration.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.infrastructure.configuration.yaml.ArrayIndex;
import com.hotels.styx.infrastructure.configuration.yaml.ObjectField;
import com.hotels.styx.infrastructure.configuration.yaml.PathElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class JsonTreeTraversal {
    JsonTreeTraversal() {
    }

    public static <T extends JsonTreeVisitor> T traverseJsonTree(JsonNode node, T visitor) {
        JsonTreeTraversal.traverseJsonTree(node, null, new ArrayList<PathElement>(), visitor);
        return visitor;
    }

    private static void traverseJsonTree(JsonNode node, ContainerNode<?> parent, List<PathElement> path, JsonTreeVisitor visitor) {
        if (node.isValueNode()) {
            visitor.onValueNode((ValueNode)node, Optional.of(parent), (List<PathElement>)ImmutableList.copyOf(path));
        } else if (node.isArray()) {
            Iterable elements = () -> ((JsonNode)node).elements();
            int index = 0;
            for (JsonNode child : elements) {
                path.add(new ArrayIndex(index));
                JsonTreeTraversal.traverseJsonTree(child, (ArrayNode)node, path, visitor);
                path.remove(path.size() - 1);
                ++index;
            }
        } else if (node.isObject()) {
            Iterable fields = () -> ((JsonNode)node).fields();
            for (Map.Entry field : fields) {
                String fieldName = (String)field.getKey();
                JsonNode child = (JsonNode)field.getValue();
                path.add(new ObjectField(fieldName));
                JsonTreeTraversal.traverseJsonTree(child, (ObjectNode)node, path, visitor);
                path.remove(path.size() - 1);
            }
        } else {
            throw new IllegalStateException("Unhandled node type: " + node.getNodeType());
        }
    }

    public static interface JsonTreeVisitor {
        public void onValueNode(ValueNode var1, Optional<ContainerNode<?>> var2, List<PathElement> var3);
    }
}

