/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.configuration.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.hotels.styx.common.Preconditions;
import com.hotels.styx.infrastructure.configuration.yaml.ArrayIndex;
import com.hotels.styx.infrastructure.configuration.yaml.ObjectField;
import com.hotels.styx.infrastructure.configuration.yaml.PathElement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class NodePath {
    private final List<PathElement> elements;

    public NodePath(String path) {
        this.elements = NodePath.splitPath(path);
        Preconditions.checkArgument((!this.elements.isEmpty() ? 1 : 0) != 0, (String)"No elements in %s", (Object[])new Object[]{path});
    }

    NodePath(List<PathElement> elements) {
        this.elements = elements;
    }

    public List<PathElement> elements() {
        return this.elements;
    }

    public PathElement lastElement() {
        return this.elements.get(this.elements.size() - 1);
    }

    public Optional<JsonNode> findMatchingDescendant(JsonNode rootNode) {
        JsonNode current = rootNode;
        for (PathElement element : this.elements) {
            current = element.child(current);
            if (current != null) continue;
            return Optional.empty();
        }
        return Optional.ofNullable(current);
    }

    public boolean override(JsonNode rootNode, JsonNode leaf) {
        JsonNode current = rootNode;
        JsonNode parent = null;
        for (PathElement element : this.elements) {
            current = element.child(parent = current);
            if (current != null) continue;
            return false;
        }
        this.lastElement().setChild(parent, leaf);
        return true;
    }

    public boolean override(JsonNode rootNode, String value) {
        return this.override(rootNode, (JsonNode)TextNode.valueOf((String)value));
    }

    private static List<PathElement> splitPath(String path) {
        return Arrays.stream(path.split("\\.")).flatMap(splitByDot -> Arrays.stream(splitByDot.split("\\["))).map(input -> {
            if (input.endsWith("]")) {
                return new ArrayIndex(Integer.parseInt(input.substring(0, input.length() - 1)));
            }
            return new ObjectField((String)input);
        }).collect(Collectors.toList());
    }

    public String toString() {
        String path = String.join((CharSequence)"", this.elements.stream().map(input -> input.isArrayIndex() ? "[" + input + "]" : "." + input).collect(Collectors.toList()));
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        return path;
    }
}

